/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectInContextImpl
implements SelectInContext {
    private final PsiFile myPsiFile;
    private final Object mySelector;

    private SelectInContextImpl(@NotNull PsiFile psiFile, @Nullable Object selector2) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/actions/SelectInContextImpl", "<init>"));
        }
        this.myPsiFile = psiFile;
        this.mySelector = selector2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myPsiFile.getProject();
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl", "getProject"));
        }
        return project2;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    public Object getSelectorInFile() {
        return ObjectUtils.notNull((Object)this.mySelector, (Object)this.myPsiFile);
    }

    @Nullable
    public FileEditorProvider getFileEditorProvider() {
        return new FileEditorProvider(){

            public FileEditor openFileEditor() {
                return (FileEditor)ArrayUtil.getFirstElement((Object[])FileEditorManager.getInstance((Project)SelectInContextImpl.this.getProject()).openFile(SelectInContextImpl.this.getVirtualFile(), false));
            }
        };
    }

    @Nullable
    public static SelectInContext createContext(AnActionEvent event) {
        VirtualFile virtualFile;
        FileEditor editor;
        Project project2 = event.getProject();
        SelectInContext result2 = SelectInContextImpl.createEditorContext(project2, editor = (FileEditor)event.getData(PlatformDataKeys.FILE_EDITOR), virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE));
        if (result2 != null) {
            return result2;
        }
        JComponent sourceComponent = SelectInContextImpl.getEventComponent(event);
        if (sourceComponent == null) {
            return null;
        }
        result2 = (SelectInContext)event.getData(SelectInContext.DATA_KEY);
        if (result2 != null) {
            return result2;
        }
        result2 = SelectInContextImpl.createPsiContext(event);
        if (result2 != null) {
            return result2;
        }
        Navigatable descriptor = (Navigatable)event.getData(CommonDataKeys.NAVIGATABLE);
        SelectInContext selectInContext = result2 = descriptor instanceof OpenFileDescriptor ? SelectInContextImpl.createDescriptorContext((OpenFileDescriptor)descriptor) : null;
        if (result2 != null) {
            return result2;
        }
        if (virtualFile != null && project2 != null) {
            return new FileSelectInContext(project2, virtualFile);
        }
        return null;
    }

    @Nullable
    private static SelectInContext createDescriptorContext(final OpenFileDescriptor descriptor) {
        Document document;
        VirtualFile file2 = descriptor.getFile();
        Document document2 = document = !file2.isValid() ? null : FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)descriptor.getProject()).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        return new SelectInContextImpl(psiFile, null){

            @Override
            public FileEditorProvider getFileEditorProvider() {
                return new FileEditorProvider(){

                    public FileEditor openFileEditor() {
                        descriptor.navigate(false);
                        Object[] allEditors = FileEditorManager.getInstance((Project)descriptor.getProject()).getAllEditors(descriptor.getFile());
                        return (FileEditor)ArrayUtil.getFirstElement((Object[])allEditors);
                    }
                };
            }
        };
    }

    private static SelectInContext createEditorContext(@Nullable Project project2, @Nullable FileEditor editor, @Nullable VirtualFile contextFile) {
        Object selectorInFile;
        PsiFile psiFile;
        if (project2 == null || editor == null) {
            return null;
        }
        VirtualFile file2 = FileEditorManagerEx.getInstanceEx(project2).getFile(editor);
        if (file2 == null) {
            file2 = contextFile;
        }
        PsiFile psiFile2 = psiFile = file2 == null ? null : PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        if (editor instanceof TextEditor) {
            return new FileEditorSelectInContext(editor, psiFile){

                public Object getSelectorInFile() {
                    PsiFile file2 = this.getPsiFile();
                    if (file2.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                        return super.getSelectorInFile();
                    }
                    Editor editor = ((TextEditor)this.getFileEditor()).getEditor();
                    int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
                    PsiElement element = file2.findElementAt(offset);
                    return element != null ? element : super.getSelectorInFile();
                }
            };
        }
        StructureViewBuilder builder = editor.getStructureViewBuilder();
        StructureView structureView = builder != null ? builder.createStructureView(editor, project2) : null;
        Object object = selectorInFile = structureView != null ? structureView.getTreeModel().getCurrentEditorElement() : null;
        if (structureView != null) {
            Disposer.dispose((Disposable)structureView);
        }
        return new SelectInContextImpl(psiFile, ObjectUtils.chooseNotNull((Object)selectorInFile, (Object)psiFile));
    }

    @Nullable
    private static SelectInContext createPsiContext(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return new SelectInContextImpl(psiFile, psiElement);
    }

    @Nullable
    private static JComponent getEventComponent(AnActionEvent event) {
        Object source;
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent != null && (source = inputEvent.getSource()) instanceof JComponent) {
            return (JComponent)source;
        }
        Component component = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        return component instanceof JComponent ? (JComponent)component : null;
    }
}

