/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ShowFilePathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ShowFilePathAction.class);
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/actions/ShowFilePathAction$1", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction$1", "hyperlinkActivated"));
            }
            URL url = e.getURL();
            if (url != null) {
                ShowFilePathAction.openFile(new File(url.getPath()));
            }
            notification.expire();
        }
    };
    private static final NullableLazyValue<String> fileManagerApp = new AtomicNullableLazyValue<String>(){

        protected String compute() {
            return ShowFilePathAction.readDesktopEntryKey("Exec").map(line -> line.split(" ")[0]).filter(exec -> exec.endsWith("nautilus") || exec.endsWith("pantheon-files")).orElse(null);
        }
    };
    private static final NotNullLazyValue<String> fileManagerName = new AtomicNotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            if (SystemInfo.isMac) {
                if ("Finder" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return "Finder";
            }
            if (SystemInfo.isWindows) {
                if ("Explorer" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return "Explorer";
            }
            String string = ShowFilePathAction.readDesktopEntryKey("Name").orElse("File Manager");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
            }
            return string;
        }
    };

    private static Optional<String> readDesktopEntryKey(String key2) {
        String appName;
        if (SystemInfo.hasXdgMime() && (appName = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-mime", "query", "default", "inode/directory"}))) != null && appName.endsWith(".desktop")) {
            return Stream.of(ShowFilePathAction.getXdgDataDirectories().split(":")).map(dir -> new File((String)dir, "applications/" + appName)).filter(File::exists).findFirst().map(file2 -> ShowFilePathAction.readDesktopEntryKey(file2, key2));
        }
        return Optional.empty();
    }

    private static String getXdgDataDirectories() {
        String dataHome = System.getenv("XDG_DATA_HOME");
        String dataDirs = System.getenv("XDG_DATA_DIRS");
        return StringUtil.defaultIfEmpty((String)dataHome, (String)(SystemProperties.getUserHome() + "/.local/share")) + ':' + StringUtil.defaultIfEmpty((String)dataDirs, (String)"/usr/local/share:/usr/share");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readDesktopEntryKey(File file2, String key2) {
        LOG.debug("looking for '" + key2 + "' in " + file2);
        String prefix = key2 + '=';
        try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
            String string = reader.lines().filter(l -> l.startsWith(prefix)).map(l -> l.substring(prefix.length())).findFirst().orElse(null);
            return string;
        }
        catch (IOException | UncheckedIOException e) {
            LOG.info("Cannot read: " + file2, (Throwable)e);
            return null;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "update"));
        }
        boolean visible = !SystemInfo.isMac && ShowFilePathAction.isSupported();
        e.getPresentation().setVisible(visible);
        if (visible) {
            VirtualFile file2 = ShowFilePathAction.getFile(e);
            e.getPresentation().setEnabled(file2 != null);
            e.getPresentation().setText(ActionsBundle.message((String)"action.ShowFilePath.tuned", (Object[])new Object[]{file2 != null && file2.isDirectory() ? 1 : 0}));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "actionPerformed"));
        }
        VirtualFile file2 = ShowFilePathAction.getFile(e);
        if (file2 != null) {
            ShowFilePathAction.show(file2, (Consumer<ListPopup>)((Consumer)popup -> {
                DataManager dataManager = DataManager.getInstance();
                if (dataManager != null) {
                    dataManager.getDataContextFromFocus().doWhenDone(arg_0 -> ((ListPopup)popup).showInBestPositionFor(arg_0));
                }
            }));
        }
    }

    @Nullable
    private static VirtualFile getFile(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        return files == null || files.length == 1 ? (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()) : null;
    }

    public static void show(@NotNull VirtualFile file2, @NotNull MouseEvent e) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        ShowFilePathAction.show(file2, (Consumer<ListPopup>)((Consumer)popup -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "lambda$show$5"));
            }
            if (e.getComponent().isShowing()) {
                popup.show(new RelativePoint(e));
            }
        }));
    }

    private static void show(@NotNull VirtualFile file2, @NotNull Consumer<ListPopup> action) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        if (!ShowFilePathAction.isSupported()) {
            return;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file2; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files.size();
            files.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/actions/ShowFilePathAction", "lambda$show$7"));
            }
            ArrayList<Icon> icons = new ArrayList<Icon>();
            for (String url : fileUrls) {
                File ioFile = new File(url);
                icons.add(ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : EmptyIcon.ICON_16);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/actions/ShowFilePathAction", "lambda$null$6"));
                }
                action.consume((Object)ShowFilePathAction.createPopup(files, icons));
            });
        });
    }

    private static String getPresentableUrl(VirtualFile file2) {
        String url = file2.getPresentableUrl();
        if (file2.getParent() == null && SystemInfo.isWindows) {
            url = url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(List<VirtualFile> files, List<Icon> icons) {
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(RevealFileAction.getActionName(), files, icons){

            @NotNull
            public String getTextFor(VirtualFile value2) {
                String string = value2.getPresentableName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$4", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> ShowFilePathAction.openFile(selectedFile));
                }
                return FINAL_CHOICE;
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.hasXdgOpen() || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    @NotNull
    public static String getFileManagerName() {
        String string = (String)fileManagerName.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction", "getFileManagerName"));
        }
        return string;
    }

    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "openFile"));
        }
        if (!file2.exists()) {
            LOG.info("does not exist: " + file2);
            return;
        }
        try {
            file2 = file2.getAbsoluteFile();
            File parent = file2.getParentFile();
            if (parent != null) {
                ShowFilePathAction.doOpen(parent, file2);
            } else {
                ShowFilePathAction.doOpen(file2, null);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/actions/ShowFilePathAction", "openDirectory"));
        }
        if (!directory.isDirectory()) {
            LOG.info("not a directory: " + directory);
            return;
        }
        try {
            ShowFilePathAction.doOpen(directory.getAbsoluteFile(), null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void doOpen(@NotNull File _dir, @Nullable File _toSelect) throws IOException, ExecutionException {
        String toSelect2;
        if (_dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_dir", "com/intellij/ide/actions/ShowFilePathAction", "doOpen"));
        }
        String dir = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_dir.getPath()));
        String string = toSelect2 = _toSelect != null ? FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_toSelect.getPath())) : null;
        if (SystemInfo.isWindows) {
            String cmd = toSelect2 != null ? "explorer /select," + toSelect2 : "explorer /root," + dir;
            LOG.debug(cmd);
            Process process2 = Runtime.getRuntime().exec(cmd);
            new CapturingProcessHandler(process2, null, cmd).runProcess().checkSuccess(LOG);
        } else if (SystemInfo.isMac) {
            GeneralCommandLine cmd = toSelect2 != null ? new GeneralCommandLine(new String[]{"open", "-R", toSelect2}) : new GeneralCommandLine(new String[]{"open", dir});
            LOG.debug(cmd.toString());
            ExecUtil.execAndGetOutput((GeneralCommandLine)cmd).checkSuccess(LOG);
        } else if (fileManagerApp.getValue() != null) {
            ShowFilePathAction.schedule(new GeneralCommandLine(new String[]{(String)fileManagerApp.getValue(), toSelect2 != null ? toSelect2 : dir}));
        } else if (SystemInfo.hasXdgOpen()) {
            ShowFilePathAction.schedule(new GeneralCommandLine(new String[]{"xdg-open", dir}));
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            LOG.debug("opening " + dir + " via desktop API");
            Desktop.getDesktop().open(new File(dir));
        } else {
            Messages.showErrorDialog((String)"This action isn't supported on the current platform", (String)"Cannot Open File");
        }
    }

    private static void schedule(GeneralCommandLine cmd) {
        PooledThreadExecutor.INSTANCE.submit(() -> {
            try {
                LOG.debug(cmd.toString());
                ExecUtil.execAndGetOutput((GeneralCommandLine)cmd).checkSuccess(LOG);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    public static void showDialog(Project project2, String message2, String title, @NotNull File file2, @Nullable DialogWrapper.DoNotAskOption option) {
        String cancel;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "showDialog"));
        }
        String ok = RevealFileAction.getActionName();
        if (Messages.showOkCancelDialog((Project)project2, (String)message2, (String)title, (String)ok, (String)(cancel = IdeBundle.message((String)"action.close", (Object[])new Object[0])), (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)option) == 0) {
            ShowFilePathAction.openFile(file2);
        }
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isInLocalFileSystem()) {
            return file2;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof ArchiveFileSystem && file2.getParent() == null) {
            return ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return null;
    }
}

