/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        List files = SynchronizeCurrentFileAction.getFiles(e).take(2).toList();
        if (e.getProject() == null || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(SynchronizeCurrentFileAction.getMessage(files));
        }
    }

    @NotNull
    private static String getMessage(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/actions/SynchronizeCurrentFileAction", "getMessage"));
        }
        VirtualFile theOnlyOne = files.size() == 1 ? files.get(0) : null;
        String string = theOnlyOne != null ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)theOnlyOne.getName(), (int)20))}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SynchronizeCurrentFileAction", "getMessage"));
        }
        return string;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e);
        List files = SynchronizeCurrentFileAction.getFiles(e).toList();
        if (project2 == null || files.isEmpty()) {
            return;
        }
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) {
                file2.getChildren();
            }
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markClean();
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
        RefreshQueue.getInstance().refresh(true, true, () -> SynchronizeCurrentFileAction.postRefresh(project2, files), (Collection)files);
    }

    private static void postRefresh(Project project2, List<VirtualFile> files) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project2);
        for (VirtualFile f : files) {
            if (f.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(f);
                continue;
            }
            dirtyScopeManager.fileDirty(f);
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        if (statusBar != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(files)}));
        }
    }

    @NotNull
    private static JBIterable<VirtualFile> getFiles(AnActionEvent e) {
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(o -> o.isInLocalFileSystem());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SynchronizeCurrentFileAction", "getFiles"));
        }
        return jBIterable;
    }
}

