/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListUtil;
import java.util.List;
import javax.swing.JList;

class DeleteBookmarkAction
extends DumbAwareAction {
    private final Project myProject;
    private final JList myList;

    DeleteBookmarkAction(Project project2, JList list2) {
        super("Delete", "Delete current bookmark", AllIcons.General.Remove);
        this.setEnabledInModalContext(true);
        this.myProject = project2;
        this.myList = list2;
        this.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), list2);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(BookmarksAction.getSelectedBookmarks(this.myList).size() > 0);
    }

    public void actionPerformed(AnActionEvent e) {
        List<Bookmark> bookmarks = BookmarksAction.getSelectedBookmarks(this.myList);
        ListUtil.removeSelectedItems((JList)this.myList);
        for (Bookmark bookmark : bookmarks) {
            BookmarkManager.getInstance(this.myProject).removeBookmark(bookmark);
        }
    }
}

