/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.CallingBackColoredTreeCellRenderer;
import com.intellij.ide.errorTreeView.CustomizeColoredTreeCellRendererReplacement;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.ClickableTreeCellRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeNodePartListener;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeRenderer
extends MultilineTreeCellRenderer {
    private final MyWrapperRenderer myWrapperRenderer;
    private final CallingBackColoredTreeCellRenderer myColoredTreeCellRenderer = new CallingBackColoredTreeCellRenderer();
    private final MyNotSelectedColoredTreeCellRenderer myRightCellRenderer = new MyNotSelectedColoredTreeCellRenderer();

    private NewErrorTreeRenderer() {
        this.myWrapperRenderer = new MyWrapperRenderer((TreeCellRenderer)((Object)this.myColoredTreeCellRenderer), this.myRightCellRenderer);
    }

    public static JScrollPane install(JTree tree) {
        NewErrorTreeRenderer renderer = new NewErrorTreeRenderer();
        new TreeNodePartListener(renderer.myRightCellRenderer).installOn(tree);
        return MultilineTreeCellRenderer.installRenderer(tree, renderer);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element = NewErrorTreeRenderer.getElement(value2);
        if (element != null) {
            CustomizeColoredTreeCellRenderer leftSelfRenderer = element.getLeftSelfRenderer();
            CustomizeColoredTreeCellRenderer rightSelfRenderer = element.getRightSelfRenderer();
            if (leftSelfRenderer != null || rightSelfRenderer != null) {
                this.myColoredTreeCellRenderer.setCurrentCallback(leftSelfRenderer);
                this.myRightCellRenderer.setCurrentCallback(rightSelfRenderer);
                return this.myWrapperRenderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
            }
        }
        return super.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
    }

    @NotNull
    public static String calcPrefix(@Nullable ErrorTreeElement element) {
        if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            String rendPrefix;
            String prefix = element.getKind().getPresentableText();
            if (element instanceof NavigatableMessageElement && !StringUtil.isEmpty((String)(rendPrefix = ((NavigatableMessageElement)element).getRendererTextPrefix()))) {
                prefix = prefix + rendPrefix + " ";
            }
            String string = prefix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/NewErrorTreeRenderer", "calcPrefix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/NewErrorTreeRenderer", "calcPrefix"));
        }
        return "";
    }

    @Override
    protected void initComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element = NewErrorTreeRenderer.getElement(value2);
        if (element instanceof GroupingElement) {
            this.setFont(this.getFont().deriveFont(1));
        }
        String prefix = NewErrorTreeRenderer.calcPrefix(element);
        if (element != null) {
            String[] text2 = element.getText();
            if (text2 == null) {
                text2 = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (text2.length > 0 && text2[0] == null) {
                text2[0] = "";
            }
            this.setText(text2, prefix);
        }
        Icon icon = null;
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            icon = groupingElement.getFile() != null ? groupingElement.getFile().getFileType().getIcon() : AllIcons.FileTypes.Any_type;
        } else if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            ErrorTreeElementKind kind2 = element.getKind();
            if (ErrorTreeElementKind.ERROR.equals((Object)kind2)) {
                icon = AllIcons.General.Error;
            } else if (ErrorTreeElementKind.WARNING.equals((Object)kind2) || ErrorTreeElementKind.NOTE.equals((Object)kind2)) {
                icon = AllIcons.General.Warning;
            } else if (ErrorTreeElementKind.INFO.equals((Object)kind2)) {
                icon = AllIcons.General.Information;
            }
        }
        this.setIcon(icon);
    }

    private static ErrorTreeElement getElement(Object value2) {
        if (!(value2 instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
        if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
            return null;
        }
        return ((ErrorTreeNodeDescriptor)((Object)userObject)).getElement();
    }

    private static class MyWrapperRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myLeft;
        private final TreeCellRenderer myRight;
        private final JPanel myPanel;

        public TreeCellRenderer getLeft() {
            return this.myLeft;
        }

        public TreeCellRenderer getRight() {
            return this.myRight;
        }

        public MyWrapperRenderer(TreeCellRenderer left, TreeCellRenderer right) {
            this.myLeft = left;
            this.myRight = right;
            this.myPanel = new JPanel(new BorderLayout());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.myPanel.removeAll();
            this.myPanel.setBackground(tree.getBackground());
            this.myPanel.add(this.myLeft.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus), "West");
            this.myPanel.add(this.myRight.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus), "East");
            return this.myPanel;
        }
    }

    private static class MyNotSelectedColoredTreeCellRenderer
    extends SimpleColoredComponent
    implements ClickableTreeCellRenderer {
        private CustomizeColoredTreeCellRenderer myCurrentCallback;

        private MyNotSelectedColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (this.myCurrentCallback instanceof CustomizeColoredTreeCellRendererReplacement) {
                return ((CustomizeColoredTreeCellRendererReplacement)this.myCurrentCallback).getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
            }
            this.clear();
            this.setBackground(UIUtil.getBgFillColor((Component)tree));
            if (this.myCurrentCallback != null) {
                this.myCurrentCallback.customizeCellRenderer((SimpleColoredComponent)this, tree, value2, selected, expanded, leaf, row, hasFocus);
            }
            if (this.getFont() == null) {
                this.setFont(tree.getFont());
            }
            return this;
        }

        @Override
        @Nullable
        public Object getTag() {
            return this.myCurrentCallback == null ? null : this.myCurrentCallback.getTag();
        }

        public void setCurrentCallback(CustomizeColoredTreeCellRenderer currentCallback) {
            this.myCurrentCallback = currentCallback;
        }
    }
}

