/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFavoritesListProvider<T>
implements FavoritesListProvider {
    public static final int BOOKMARKS_WEIGHT = 100;
    public static final int BREAKPOINTS_WEIGHT = 200;
    public static final int TASKS_WEIGHT = 300;
    protected final Project myProject;
    private final String myListName;
    protected final List<AbstractTreeNode<T>> myChildren;
    protected final FavoritesListNode myNode;

    protected AbstractFavoritesListProvider(@NotNull Project project2, String listName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "<init>"));
        }
        this(project2, listName, null);
    }

    protected AbstractFavoritesListProvider(@NotNull Project project2, String listName, @Nullable String description) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "<init>"));
        }
        this.myChildren = new ArrayList<AbstractTreeNode<T>>();
        this.myProject = project2;
        this.myListName = listName;
        this.myNode = new FavoritesListNode(project2, listName, description){

            @Override
            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                List list2 = AbstractFavoritesListProvider.this.myChildren;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider$1", "getChildren"));
                }
                return list2;
            }

            @Override
            public FavoritesListProvider getProvider() {
                return AbstractFavoritesListProvider.this;
            }
        };
    }

    @Override
    public String getListName(Project project2) {
        return this.myListName;
    }

    @Override
    @Nullable
    public FavoritesListNode createFavoriteListNode(Project project2) {
        return this.myNode;
    }

    @Override
    public int compare(FavoritesTreeNodeDescriptor o1, FavoritesTreeNodeDescriptor o2) {
        return o1.getIndex() - o2.getIndex();
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "getCustomName"));
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type2, Project project2, @NotNull Set<Object> selectedObjects) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "willHandle"));
        }
        if (selectedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedObjects", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "willHandle"));
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type2, Project project2, @NotNull Set<Object> selectedObjects, JComponent component) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "handle"));
        }
        if (selectedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedObjects", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "handle"));
        }
    }

    @Override
    public int compareTo(FavoritesListProvider o) {
        if (this.getWeight() > o.getWeight()) {
            return 1;
        }
        if (this.getWeight() < o.getWeight()) {
            return -1;
        }
        return 0;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "customizeRenderer"));
        }
    }
}

