/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.smartPointerPsiNodes;

import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.BaseSmartPointerPsiNode;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.FieldSmartPointerNode;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.MethodSmartPointerNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.PsiClassChildrenSource;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ClassSmartPointerNode
extends BaseSmartPointerPsiNode<SmartPsiElementPointer> {
    public ClassSmartPointerNode(Project project2, PsiClass value2, ViewSettings viewSettings) {
        super(project2, SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)value2), viewSettings);
    }

    public ClassSmartPointerNode(Project project2, Object value2, ViewSettings viewSettings) {
        this(project2, (PsiClass)value2, viewSettings);
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiClass parent = this.getPsiClass();
        final ArrayList<AbstractTreeNode> treeNodes = new ArrayList<AbstractTreeNode>();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        if (this.getSettings().isShowMembers()) {
            PsiClassChildrenSource.DEFAULT_CHILDREN.addChildren(parent, result2);
            for (PsiElement psiElement : result2) {
                psiElement.accept((PsiElementVisitor)new JavaElementVisitor(){

                    public void visitClass(PsiClass aClass) {
                        treeNodes.add(new ClassSmartPointerNode(ClassSmartPointerNode.this.getProject(), aClass, ClassSmartPointerNode.this.getSettings()));
                    }

                    public void visitMethod(PsiMethod method) {
                        treeNodes.add(new MethodSmartPointerNode(ClassSmartPointerNode.this.getProject(), method, ClassSmartPointerNode.this.getSettings()));
                    }

                    public void visitField(PsiField field) {
                        treeNodes.add(new FieldSmartPointerNode(ClassSmartPointerNode.this.getProject(), field, ClassSmartPointerNode.this.getSettings()));
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        this.visitExpression((PsiExpression)expression2);
                    }
                });
            }
        }
        ArrayList<AbstractTreeNode> arrayList = treeNodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/ClassSmartPointerNode", "getChildrenImpl"));
        }
        return arrayList;
    }

    public boolean isAlwaysLeaf() {
        return !this.getSettings().isShowMembers();
    }

    @Override
    public void updateImpl(PresentationData data) {
        PsiClass aClass = this.getPsiClass();
        if (aClass != null) {
            data.setPresentableText(aClass.getName());
        }
    }

    public boolean isTopLevel() {
        return this.getPsiElement() != null && this.getPsiElement().getParent() instanceof PsiFile;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public PsiClass getPsiClass() {
        return (PsiClass)this.getPsiElement();
    }

    public boolean isAlwaysExpand() {
        return this.getParentValue() instanceof PsiFile;
    }
}

