/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateTokenType;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.fileTemplates.impl._FileTemplateTextLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateConfigurable
implements Configurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable");
    @NonNls
    private static final String EMPTY_HTML = "<html></html>";
    private JPanel myMainPanel;
    private FileTemplate myTemplate;
    private PsiFile myFile;
    private Editor myTemplateEditor;
    private JTextField myNameField;
    private JTextField myExtensionField;
    private JCheckBox myAdjustBox;
    private JCheckBox myLiveTemplateBox;
    private JPanel myTopPanel;
    private JEditorPane myDescriptionComponent;
    private boolean myModified;
    private URL myDefaultDescriptionUrl;
    private final Project myProject;
    private final List<ChangeListener> myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Splitter mySplitter;
    private final FileType myVelocityFileType = FileTypeManager.getInstance().getFileTypeByExtension("ft");
    private float myProportion = 0.6f;

    public FileTemplateConfigurable(Project project2) {
        this.myProject = project2;
    }

    public FileTemplate getTemplate() {
        return this.myTemplate;
    }

    public void setTemplate(FileTemplate template, URL defaultDescription) {
        this.myDefaultDescriptionUrl = defaultDescription;
        this.myTemplate = template;
        if (this.myMainPanel != null) {
            this.reset();
            this.myNameField.selectAll();
            this.myExtensionField.selectAll();
        }
    }

    void setShowInternalMessage(String message2) {
        this.myTopPanel.removeAll();
        if (message2 == null) {
            this.myTopPanel.add((Component)new JLabel(IdeBundle.message((String)"label.name", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)2), 0, 0));
            this.myTopPanel.add((Component)this.myNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)3, (int)2), 0, 0));
            this.myTopPanel.add((Component)new JLabel(IdeBundle.message((String)"label.extension", (Object[])new Object[0])), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insets((int)0, (int)2), 0, 0));
            this.myTopPanel.add((Component)this.myExtensionField, new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 2, (Insets)JBUI.insetsLeft((int)2), 0, 0));
            this.myExtensionField.setColumns(7);
        }
        this.myMainPanel.revalidate();
        this.myTopPanel.repaint();
    }

    void setShowAdjustCheckBox(boolean show) {
        this.myAdjustBox.setEnabled(show);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.edit.file.template", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myNameField = new JTextField();
        this.myExtensionField = new JTextField();
        this.mySplitter = new Splitter(true, this.myProportion);
        this.myAdjustBox = new JCheckBox(IdeBundle.message((String)"checkbox.reformat.according.to.style", (Object[])new Object[0]));
        this.myLiveTemplateBox = new JCheckBox(IdeBundle.message((String)"checkbox.enable.live.templates", (Object[])new Object[0]));
        this.myTemplateEditor = this.createEditor();
        this.myDescriptionComponent = new JEditorPane();
        this.myDescriptionComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myDescriptionComponent.setText(EMPTY_HTML);
        this.myDescriptionComponent.setEditable(false);
        this.myDescriptionComponent.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.myTopPanel = new JPanel(new GridBagLayout());
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        descriptionPanel.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.description", (Object[])new Object[0]), null), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insetsBottom((int)2), 0, 0));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myDescriptionComponent), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
        this.myMainPanel.add((Component)this.myTopPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myMainPanel.add((Component)this.mySplitter, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.mySplitter.setSecondComponent((JComponent)descriptionPanel);
        this.setShowInternalMessage(null);
        this.myNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$1", "focusLost"));
                }
                FileTemplateConfigurable.this.onNameChanged();
            }
        });
        this.myExtensionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$2", "focusLost"));
                }
                FileTemplateConfigurable.this.onNameChanged();
            }
        });
        this.myMainPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        return this.myMainPanel;
    }

    public void setProportion(float proportion) {
        this.myProportion = proportion;
    }

    private Editor createEditor() {
        Document doc;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = this.myFile == null ? editorFactory.createDocument((CharSequence)(this.myTemplate == null ? "" : this.myTemplate.getText())) : (doc = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile));
        assert (doc != null);
        Editor editor = editorFactory.createEditor(doc, this.myProject);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(3);
        editorSettings.setAdditionalLinesCount(3);
        editorSettings.setCaretRowShown(false);
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                FileTemplateConfigurable.this.onTextChanged();
            }
        });
        ((EditorEx)editor).setHighlighter(this.createHighlighter());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel((LayoutManager)new HorizontalLayout(40));
        southPanel.add(this.myAdjustBox);
        southPanel.add(this.myLiveTemplateBox);
        topPanel.add((Component)southPanel, "South");
        topPanel.add((Component)editor.getComponent(), "Center");
        this.mySplitter.setFirstComponent((JComponent)topPanel);
        return editor;
    }

    private void onTextChanged() {
        this.myModified = true;
    }

    private void onNameChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable", "addChangeListener"));
        }
        if (!this.myChangeListeners.contains(listener2)) {
            this.myChangeListeners.add(listener2);
        }
    }

    public void removeChangeListener(ChangeListener listener2) {
        this.myChangeListeners.remove(listener2);
    }

    public boolean isModified() {
        String extension;
        if (this.myModified) {
            return true;
        }
        String name2 = this.myTemplate == null ? "" : this.myTemplate.getName();
        String string = extension = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        if (!Comparing.equal((String)name2, (String)this.myNameField.getText())) {
            return true;
        }
        if (!Comparing.equal((String)extension, (String)this.myExtensionField.getText())) {
            return true;
        }
        return this.myTemplate != null && (this.myTemplate.isReformatCode() != this.myAdjustBox.isSelected() || this.myTemplate.isLiveTemplateEnabled() != this.myLiveTemplateBox.isSelected());
    }

    public void apply() throws ConfigurationException {
        if (this.myTemplate != null) {
            this.myTemplate.setText(this.myTemplateEditor.getDocument().getText());
            String name2 = this.myNameField.getText();
            String extension = this.myExtensionField.getText();
            String filename = name2 + "." + extension;
            if (name2.length() == 0 || !FileTemplateConfigurable.isValidFilename(filename)) {
                throw new ConfigurationException(IdeBundle.message((String)"error.invalid.template.file.name.or.extension", (Object[])new Object[0]));
            }
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filename);
            if (fileType == UnknownFileType.INSTANCE) {
                FileTypeChooser.associateFileType(filename);
            }
            this.myTemplate.setName(name2);
            this.myTemplate.setExtension(extension);
            this.myTemplate.setReformatCode(this.myAdjustBox.isSelected());
            this.myTemplate.setLiveTemplateEnabled(this.myLiveTemplateBox.isSelected());
        }
        this.myModified = false;
    }

    private static boolean isValidFilename(String filename) {
        if (filename.contains("/") || filename.contains("\\") || filename.contains(":")) {
            return false;
        }
        File tempFile = new File(FileUtil.getTempDirectory() + File.separator + filename);
        return FileUtil.ensureCanCreateFile((File)tempFile);
    }

    public void reset() {
        String description;
        String text2 = this.myTemplate == null ? "" : this.myTemplate.getText();
        String name2 = this.myTemplate == null ? "" : this.myTemplate.getName();
        String extension = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        String string = description = this.myTemplate == null ? "" : this.myTemplate.getDescription();
        if (description.isEmpty() && this.myDefaultDescriptionUrl != null) {
            try {
                description = UrlUtil.loadText(this.myDefaultDescriptionUrl);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
        this.myFile = this.createFile(text2, name2);
        this.myTemplateEditor = this.createEditor();
        this.myNameField.setText(name2);
        this.myExtensionField.setText(extension);
        this.myAdjustBox.setSelected(this.myTemplate != null && this.myTemplate.isReformatCode());
        this.myLiveTemplateBox.setSelected(this.myTemplate != null && this.myTemplate.isLiveTemplateEnabled());
        int i2 = description.indexOf("<html>");
        if (i2 > 0) {
            description = description.substring(i2);
        }
        description = XmlStringUtil.stripHtml((String)description);
        description = description.replace("\n", "").replace("\r", "");
        description = XmlStringUtil.stripHtml((String)description);
        description = description + "<hr> <font face=\"verdana\" size=\"-1\"><a href='http://velocity.apache.org/engine/devel/user-guide.html#Velocity_Template_Language_VTL:_An_Introduction'>\nApache Velocity</a> template language is used</font>";
        this.myDescriptionComponent.setText(description);
        this.myDescriptionComponent.setCaretPosition(0);
        this.myNameField.setEditable(this.myTemplate != null && !this.myTemplate.isDefault());
        this.myExtensionField.setEditable(this.myTemplate != null && !this.myTemplate.isDefault());
        this.myModified = false;
    }

    @Nullable
    private PsiFile createFile(String text2, String name2) {
        if (this.myTemplate == null) {
            return null;
        }
        FileType fileType = this.myVelocityFileType;
        if (fileType == FileTypes.UNKNOWN) {
            return null;
        }
        PsiFile file2 = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(name2 + ".txt.ft", fileType, (CharSequence)text2, 0L, true);
        file2.getViewProvider().putUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES, (Object)FileTemplateManager.getInstance(this.myProject).getDefaultProperties());
        return file2;
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
        if (this.myTemplateEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
            this.myTemplateEditor = null;
        }
        this.myFile = null;
    }

    private EditorHighlighter createHighlighter() {
        SyntaxHighlighter originalHighlighter;
        if (this.myTemplate != null && this.myVelocityFileType != FileTypes.UNKNOWN) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)new LightVirtualFile("aaa." + this.myTemplate.getExtension() + ".ft"));
        }
        LanguageFileType fileType = null;
        if (this.myTemplate != null) {
            fileType = FileTypeManager.getInstance().getFileTypeByExtension(this.myTemplate.getExtension());
        }
        if (fileType == null) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        if ((originalHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null)) == null) {
            originalHighlighter = new PlainSyntaxHighlighter();
        }
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        LayeredLexerEditorHighlighter highlighter = new LayeredLexerEditorHighlighter((SyntaxHighlighter)new TemplateHighlighter(), scheme2);
        highlighter.registerLayer(FileTemplateTokenType.TEXT, new LayerDescriptor(originalHighlighter, ""));
        return highlighter;
    }

    @NotNull
    @VisibleForTesting
    public static Lexer createDefaultLexer() {
        MergingLexerAdapter mergingLexerAdapter = new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _FileTemplateTextLexer()), TokenSet.create((IElementType[])new IElementType[]{FileTemplateTokenType.TEXT}));
        if (mergingLexerAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable", "createDefaultLexer"));
        }
        return mergingLexerAdapter;
    }

    public void focusToNameField() {
        this.myNameField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myNameField, true));
    }

    public void focusToExtensionField() {
        this.myExtensionField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myExtensionField, true));
    }

    private static class TemplateHighlighter
    extends SyntaxHighlighterBase {
        private final Lexer myLexer = FileTemplateConfigurable.createDefaultLexer();

        @NotNull
        public Lexer getHighlightingLexer() {
            Lexer lexer = this.myLexer;
            if (lexer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter", "getHighlightingLexer"));
            }
            return lexer;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            if (tokenType == FileTemplateTokenType.MACRO || tokenType == FileTemplateTokenType.DIRECTIVE) {
                TextAttributesKey[] textAttributesKeyArray = TemplateHighlighter.pack((TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
                if (textAttributesKeyArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter", "getTokenHighlights"));
                }
                return textAttributesKeyArray;
            }
            if (EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter", "getTokenHighlights"));
            }
            return EMPTY;
        }
    }
}

