/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class UrlUtil {
    private static final String JAR_SEPARATOR = "!/";
    private static final String URL_PATH_SEPARATOR = "/";
    private static final String FILE_PROTOCOL = "file";
    private static final String FILE_PROTOCOL_PREFIX = "file:";

    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        String string;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/fileTemplates/impl/UrlUtil", "loadText"));
        }
        try (BufferedInputStream stream = new BufferedInputStream(URLUtil.openStream((URL)url));){
            String string2 = new String(FileUtil.loadBytes((InputStream)stream), "UTF-8");
            string = string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/UrlUtil", "loadText"));
        }
        return string;
    }

    @NotNull
    public static List<String> getChildrenRelativePaths(@NotNull URL root) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildrenRelativePaths"));
        }
        String protocol = root.getProtocol();
        if ("jar".equalsIgnoreCase(protocol)) {
            List<String> list2 = UrlUtil.getChildPathsFromJar(root);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildrenRelativePaths"));
            }
            return list2;
        }
        if (FILE_PROTOCOL.equalsIgnoreCase(protocol)) {
            List<String> list3 = UrlUtil.getChildPathsFromFile(root);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildrenRelativePaths"));
            }
            return list3;
        }
        List<String> list4 = Collections.emptyList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildrenRelativePaths"));
        }
        return list4;
    }

    @NotNull
    private static List<String> getChildPathsFromFile(@NotNull URL root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildPathsFromFile"));
        }
        final ArrayList<String> paths = new ArrayList<String>();
        File rootFile = new File(FileUtil.unquote((String)root.getPath()));
        new Object(){

            void collectFiles(File fromFile, String prefix) {
                File[] list2 = fromFile.listFiles();
                if (list2 != null) {
                    for (File file2 : list2) {
                        String childRelativePath;
                        String string = childRelativePath = prefix.isEmpty() ? file2.getName() : prefix + UrlUtil.URL_PATH_SEPARATOR + file2.getName();
                        if (file2.isDirectory()) {
                            this.collectFiles(file2, childRelativePath);
                            continue;
                        }
                        paths.add(childRelativePath);
                    }
                }
            }
        }.collectFiles(rootFile, "");
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildPathsFromFile"));
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getChildPathsFromJar(@NotNull URL root) throws IOException {
        ArrayList<String> arrayList;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildPathsFromJar"));
        }
        String file2 = root.getFile();
        file2 = StringUtil.trimStart((String)file2, (String)FILE_PROTOCOL_PREFIX);
        int jarSeparatorIndex = file2.indexOf(JAR_SEPARATOR);
        assert (jarSeparatorIndex > 0);
        String rootDirName = file2.substring(jarSeparatorIndex + 2);
        if (!rootDirName.endsWith(URL_PATH_SEPARATOR)) {
            rootDirName = rootDirName + URL_PATH_SEPARATOR;
        }
        try (ZipFile zipFile = new ZipFile(FileUtil.unquote((String)file2.substring(0, jarSeparatorIndex)));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<String> paths = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                String relPath;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(relPath = entry.getName()).startsWith(rootDirName)) continue;
                paths.add(relPath.substring(rootDirName.length()));
            }
            ArrayList<String> arrayList2 = paths;
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/UrlUtil", "getChildPathsFromJar"));
        }
        return arrayList;
    }
}

