/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.ModifyKeywordDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeEditor
extends SettingsEditor<AbstractFileType> {
    private final JTextField myFileTypeName = new JTextField();
    private final JTextField myFileTypeDescr = new JTextField();
    private final JCheckBox myIgnoreCase = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.ignore.case", (Object[])new Object[0]));
    private final JCheckBox mySupportBraces = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.braces", (Object[])new Object[0]));
    private final JCheckBox mySupportBrackets = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.brackets", (Object[])new Object[0]));
    private final JCheckBox mySupportParens = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.parens", (Object[])new Object[0]));
    private final JCheckBox mySupportEscapes = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.string.escapes", (Object[])new Object[0]));
    private final JTextField myLineComment = new JTextField(5);
    private final JCheckBox myCommentAtLineStart = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"&Only at line start"));
    private final JTextField myBlockCommentStart = new JTextField(5);
    private final JTextField myBlockCommentEnd = new JTextField(5);
    private final JTextField myHexPrefix = new JTextField(5);
    private final JTextField myNumPostfixes = new JTextField(5);
    private final JBList[] myKeywordsLists = new JBList[]{new JBList(), new JBList(), new JBList(), new JBList()};
    private final DefaultListModel[] myKeywordModels = new DefaultListModel[]{new DefaultListModel(), new DefaultListModel(), new DefaultListModel(), new DefaultListModel()};

    public CustomFileTypeEditor() {
        this.myLineComment.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                boolean enabled = StringUtil.isNotEmpty((String)CustomFileTypeEditor.this.myLineComment.getText());
                CustomFileTypeEditor.this.myCommentAtLineStart.setEnabled(enabled);
                if (!enabled) {
                    CustomFileTypeEditor.this.myCommentAtLineStart.setSelected(false);
                }
            }
        });
        this.myCommentAtLineStart.setEnabled(false);
    }

    public void resetEditorFrom(@NotNull AbstractFileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeEditor", "resetEditorFrom"));
        }
        this.myFileTypeName.setText(fileType.getName());
        this.myFileTypeDescr.setText(fileType.getDescription());
        SyntaxTable table = fileType.getSyntaxTable();
        if (table != null) {
            this.myLineComment.setText(table.getLineComment());
            this.myBlockCommentEnd.setText(table.getEndComment());
            this.myBlockCommentStart.setText(table.getStartComment());
            this.myHexPrefix.setText(table.getHexPrefix());
            this.myNumPostfixes.setText(table.getNumPostfixChars());
            this.myIgnoreCase.setSelected(table.isIgnoreCase());
            this.myCommentAtLineStart.setSelected(table.lineCommentOnlyAtStart);
            this.mySupportBraces.setSelected(table.isHasBraces());
            this.mySupportBrackets.setSelected(table.isHasBrackets());
            this.mySupportParens.setSelected(table.isHasParens());
            this.mySupportEscapes.setSelected(table.isHasStringEscapes());
            table.getKeywords1().stream().sorted().forEach(s -> this.myKeywordModels[0].addElement(s));
            table.getKeywords2().stream().sorted().forEach(s -> this.myKeywordModels[1].addElement(s));
            table.getKeywords3().stream().sorted().forEach(s -> this.myKeywordModels[2].addElement(s));
            table.getKeywords4().stream().sorted().forEach(s -> this.myKeywordModels[3].addElement(s));
        }
    }

    public void applyEditorTo(@NotNull AbstractFileType type2) throws ConfigurationException {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeEditor", "applyEditorTo"));
        }
        if (this.myFileTypeName.getText().trim().length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"error.name.cannot.be.empty", (Object[])new Object[0]), CommonBundle.getErrorTitle());
        }
        if (this.myFileTypeDescr.getText().trim().length() == 0) {
            this.myFileTypeDescr.setText(this.myFileTypeName.getText());
        }
        type2.setName(this.myFileTypeName.getText());
        type2.setDescription(this.myFileTypeDescr.getText());
        type2.setSyntaxTable(this.getSyntaxTable());
    }

    @NotNull
    public JComponent createEditor() {
        JComponent panel2 = this.createCenterPanel();
        for (int i = 0; i < this.myKeywordsLists.length; ++i) {
            this.myKeywordsLists[i].setModel((ListModel)this.myKeywordModels[i]);
        }
        JComponent jComponent = panel2;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeEditor", "createEditor"));
        }
        return jComponent;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel fileTypePanel = new JPanel(new BorderLayout());
        JPanel info = FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"editbox.customfiletype.name", (Object[])new Object[0]), (JComponent)this.myFileTypeName).addLabeledComponent(IdeBundle.message((String)"editbox.customfiletype.description", (Object[])new Object[0]), (JComponent)this.myFileTypeDescr).getPanel();
        info.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        fileTypePanel.add((Component)info, "North");
        JPanel highlighterPanel = new JPanel();
        highlighterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.customfiletype.syntax.highlighting", (Object[])new Object[0]), (boolean)false));
        highlighterPanel.setLayout(new BorderLayout());
        JPanel commentsAndNumbersPanel = new JPanel();
        commentsAndNumbersPanel.setLayout(new GridBagLayout());
        JPanel _panel1 = new JPanel(new BorderLayout());
        GridBag gb = new GridBag().setDefaultFill(2).setDefaultAnchor(17).setDefaultInsets(1, 5, 1, 5);
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.line.comment", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myLineComment, gb.next());
        commentsAndNumbersPanel.add((Component)this.myCommentAtLineStart, gb.next().coverLine(2));
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.start", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myBlockCommentStart, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.end", (Object[])new Object[0])), gb.next());
        commentsAndNumbersPanel.add((Component)this.myBlockCommentEnd, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.hex.prefix", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myHexPrefix, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.number.postfixes", (Object[])new Object[0])), gb.next());
        commentsAndNumbersPanel.add((Component)this.myNumPostfixes, gb.next());
        commentsAndNumbersPanel.add((Component)this.mySupportBraces, gb.nextLine().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportBrackets, gb.next().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportParens, gb.nextLine().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportEscapes, gb.next().next().coverLine(2));
        _panel1.add((Component)commentsAndNumbersPanel, "West");
        highlighterPanel.add((Component)_panel1, "North");
        TabbedPaneWrapper tabbedPaneWrapper = new TabbedPaneWrapper((Disposable)this);
        tabbedPaneWrapper.getComponent().setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"listbox.customfiletype.keywords", (Object[])new Object[0]), (boolean)false));
        tabbedPaneWrapper.addTab(" 1 ", this.createKeywordsPanel(0));
        tabbedPaneWrapper.addTab(" 2 ", this.createKeywordsPanel(1));
        tabbedPaneWrapper.addTab(" 3 ", this.createKeywordsPanel(2));
        tabbedPaneWrapper.addTab(" 4 ", this.createKeywordsPanel(3));
        highlighterPanel.add((Component)tabbedPaneWrapper.getComponent(), "Center");
        highlighterPanel.add((Component)this.myIgnoreCase, "South");
        fileTypePanel.add((Component)highlighterPanel, "Center");
        panel2.add(fileTypePanel);
        for (int i = 0; i < this.myKeywordsLists.length; ++i) {
            final int idx = i;
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    CustomFileTypeEditor.this.edit(idx);
                    return true;
                }
            }.installOn((Component)this.myKeywordsLists[i]);
        }
        return panel2;
    }

    private JPanel createKeywordsPanel(final int index) {
        JPanel panel2 = ToolbarDecorator.createDecorator((JList)this.myKeywordsLists[index]).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ModifyKeywordDialog dialog2 = new ModifyKeywordDialog((Component)CustomFileTypeEditor.this.myKeywordsLists[index], "");
                if (dialog2.showAndGet()) {
                    String keywordName = dialog2.getKeywordName();
                    if (!CustomFileTypeEditor.this.myKeywordModels[index].contains(keywordName)) {
                        CustomFileTypeEditor.this.myKeywordModels[index].addElement(keywordName);
                    }
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListUtil.removeSelectedItems((JList)CustomFileTypeEditor.this.myKeywordsLists[index]);
            }
        }).disableUpDownActions().createPanel();
        panel2.setBorder(null);
        return panel2;
    }

    private void edit(int index) {
        if (this.myKeywordsLists[index].getSelectedIndex() == -1) {
            return;
        }
        ModifyKeywordDialog dialog2 = new ModifyKeywordDialog((Component)this.myKeywordsLists[index], (String)this.myKeywordsLists[index].getSelectedValue());
        if (dialog2.showAndGet()) {
            this.myKeywordModels[index].setElementAt(dialog2.getKeywordName(), this.myKeywordsLists[index].getSelectedIndex());
        }
    }

    public SyntaxTable getSyntaxTable() {
        int i;
        SyntaxTable syntaxTable = new SyntaxTable();
        syntaxTable.setLineComment(this.myLineComment.getText());
        syntaxTable.setStartComment(this.myBlockCommentStart.getText());
        syntaxTable.setEndComment(this.myBlockCommentEnd.getText());
        syntaxTable.setHexPrefix(this.myHexPrefix.getText());
        syntaxTable.setNumPostfixChars(this.myNumPostfixes.getText());
        syntaxTable.lineCommentOnlyAtStart = this.myCommentAtLineStart.isSelected();
        boolean ignoreCase = this.myIgnoreCase.isSelected();
        syntaxTable.setIgnoreCase(ignoreCase);
        syntaxTable.setHasBraces(this.mySupportBraces.isSelected());
        syntaxTable.setHasBrackets(this.mySupportBrackets.isSelected());
        syntaxTable.setHasParens(this.mySupportParens.isSelected());
        syntaxTable.setHasStringEscapes(this.mySupportEscapes.isSelected());
        for (i = 0; i < this.myKeywordModels[0].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword1(((String)this.myKeywordModels[0].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword1((String)this.myKeywordModels[0].getElementAt(i));
        }
        for (i = 0; i < this.myKeywordModels[1].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword2(((String)this.myKeywordModels[1].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword2((String)this.myKeywordModels[1].getElementAt(i));
        }
        for (i = 0; i < this.myKeywordModels[2].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword3(((String)this.myKeywordModels[2].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword3((String)this.myKeywordModels[2].getElementAt(i));
        }
        for (i = 0; i < this.myKeywordModels[3].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword4(((String)this.myKeywordModels[3].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword4((String)this.myKeywordModels[3].getElementAt(i));
        }
        return syntaxTable;
    }
}

