/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class ProjectViewSelectInGroupTarget
implements CompositeSelectInTarget,
DumbAware {
    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/ProjectViewSelectInGroupTarget", "getSubTargets"));
        }
        Collection<SelectInTarget> collection = ProjectView.getInstance(context.getProject()).getSelectInTargets();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectViewSelectInGroupTarget", "getSubTargets"));
        }
        return collection;
    }

    public boolean canSelect(SelectInContext context) {
        ProjectView projectView = ProjectView.getInstance(context.getProject());
        Collection<SelectInTarget> targets = projectView.getSelectInTargets();
        for (SelectInTarget projectViewTarget : targets) {
            if (!projectViewTarget.canSelect(context)) continue;
            return true;
        }
        return false;
    }

    public void selectIn(final SelectInContext context, final boolean requestFocus) {
        ProjectView projectView = ProjectView.getInstance(context.getProject());
        Collection<SelectInTarget> targets = projectView.getSelectInTargets();
        LinkedHashSet<SelectInTarget> targetsToCheck = new LinkedHashSet<SelectInTarget>();
        String currentId = projectView.getCurrentViewId();
        for (SelectInTarget projectViewTarget : targets) {
            if (!Comparing.equal((String)currentId, (String)projectViewTarget.getMinorViewId())) continue;
            targetsToCheck.add(projectViewTarget);
            break;
        }
        targetsToCheck.addAll(targets);
        for (final SelectInTarget target2 : targetsToCheck) {
            if (!target2.canSelect(context)) continue;
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)context.getProject()).requestFocus(new FocusCommand(){

                    @NotNull
                    public ActionCallback run() {
                        target2.selectIn(context, requestFocus);
                        ActionCallback actionCallback = ActionCallback.DONE;
                        if (actionCallback == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectViewSelectInGroupTarget$1", "run"));
                        }
                        return actionCallback;
                    }
                }, true);
                break;
            }
            target2.selectIn(context, requestFocus);
            break;
        }
    }

    public String getToolWindowId() {
        return ToolWindowId.PROJECT_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 0.0f;
    }

    public String toString() {
        return "Project View";
    }
}

