/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ProjectTopics;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarKeyboardCommand;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class NavBarListener
extends WolfTheProblemSolver.ProblemListener
implements ActionListener,
FocusListener,
FileStatusListener,
AnActionListener,
FileEditorManagerListener,
PsiTreeChangeListener,
ModuleRootListener,
NavBarModelListener,
PropertyChangeListener,
KeyListener,
WindowFocusListener,
LafManagerListener {
    private static final String LISTENER = "NavBarListener";
    private static final String BUS = "NavBarMessageBus";
    private final NavBarPanel myPanel;
    private boolean shouldFocusEditor = false;

    static void subscribeTo(NavBarPanel panel2) {
        if (panel2.getClientProperty(LISTENER) != null) {
            NavBarListener.unsubscribeFrom(panel2);
        }
        NavBarListener listener2 = new NavBarListener(panel2);
        Project project2 = panel2.getProject();
        panel2.putClientProperty(LISTENER, listener2);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(listener2);
        FileStatusManager.getInstance((Project)project2).addFileStatusListener((FileStatusListener)listener2);
        PsiManager.getInstance((Project)project2).addPsiTreeChangeListener((PsiTreeChangeListener)listener2);
        WolfTheProblemSolver.getInstance((Project)project2).addProblemListener((WolfTheProblemSolver.ProblemListener)listener2);
        ActionManager.getInstance().addAnActionListener((AnActionListener)listener2);
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
        connection.subscribe(NavBarModelListener.NAV_BAR, (Object)listener2);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        panel2.putClientProperty(BUS, connection);
        panel2.addKeyListener(listener2);
        if (panel2.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent(panel2);
            if (window != null) {
                window.addWindowFocusListener(listener2);
            }
        } else {
            LafManager.getInstance().addLafManagerListener((LafManagerListener)listener2);
        }
    }

    static void unsubscribeFrom(NavBarPanel panel2) {
        NavBarListener listener2 = (NavBarListener)panel2.getClientProperty(LISTENER);
        panel2.putClientProperty(LISTENER, null);
        if (listener2 != null) {
            Project project2 = panel2.getProject();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(listener2);
            FileStatusManager.getInstance((Project)project2).removeFileStatusListener((FileStatusListener)listener2);
            PsiManager.getInstance((Project)project2).removePsiTreeChangeListener((PsiTreeChangeListener)listener2);
            WolfTheProblemSolver.getInstance((Project)project2).removeProblemListener((WolfTheProblemSolver.ProblemListener)listener2);
            ActionManager.getInstance().removeAnActionListener((AnActionListener)listener2);
            MessageBusConnection connection = (MessageBusConnection)panel2.getClientProperty(BUS);
            panel2.putClientProperty(BUS, null);
            if (connection != null) {
                connection.disconnect();
            }
            LafManager.getInstance().removeLafManagerListener((LafManagerListener)listener2);
        }
    }

    NavBarListener(NavBarPanel panel2) {
        this.myPanel = panel2;
        for (NavBarKeyboardCommand command : NavBarKeyboardCommand.values()) {
            this.registerKey(command);
        }
        this.myPanel.addFocusListener(this);
    }

    private void registerKey(NavBarKeyboardCommand cmd) {
        this.myPanel.registerKeyboardAction(this, cmd.name(), cmd.getKeyStroke(), 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NavBarKeyboardCommand cmd = NavBarKeyboardCommand.fromString(e.getActionCommand());
        if (cmd != null) {
            switch (cmd) {
                case LEFT: {
                    this.myPanel.moveLeft();
                    break;
                }
                case RIGHT: {
                    this.myPanel.moveRight();
                    break;
                }
                case HOME: {
                    this.myPanel.moveHome();
                    break;
                }
                case END: {
                    this.myPanel.moveEnd();
                    break;
                }
                case DOWN: {
                    this.myPanel.moveDown();
                    break;
                }
                case UP: {
                    this.myPanel.moveDown();
                    break;
                }
                case ENTER: {
                    this.myPanel.enter();
                    break;
                }
                case ESCAPE: {
                    this.myPanel.escape();
                    break;
                }
                case NAVIGATE: {
                    this.myPanel.navigate();
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getOppositeComponent() == null && this.shouldFocusEditor) {
            this.shouldFocusEditor = false;
            ToolWindowManager.getInstance((Project)this.myPanel.getProject()).activateEditorComponent();
            return;
        }
        this.myPanel.updateItems();
        List<NavBarItem> items = this.myPanel.getItems();
        if (!this.myPanel.isInFloatingMode() && items.size() > 0) {
            this.myPanel.setContextComponent((Component)((Object)items.get(items.size() - 1)));
        } else {
            this.myPanel.setContextComponent(null);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.myPanel.getProject().isDisposed()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
            return;
        }
        final DialogWrapper dialog2 = DialogWrapper.findInstance((Component)e.getOppositeComponent());
        boolean bl = this.shouldFocusEditor = dialog2 != null;
        if (dialog2 != null) {
            Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)new Disposable(){

                public void dispose() {
                    if (dialog2.getExitCode() == 1) {
                        NavBarListener.this.shouldFocusEditor = false;
                    }
                }
            });
        }
        SwingUtilities.invokeLater(() -> this.processFocusLost(e));
    }

    private void processFocusLost(FocusEvent e) {
        boolean childPopupInactive;
        Component opposite = e.getOppositeComponent();
        if (this.myPanel.isInFloatingMode() && opposite != null && DialogWrapper.findInstance((Component)opposite) != null) {
            this.myPanel.hideHint();
            return;
        }
        boolean nodePopupInactive = !this.myPanel.isNodePopupActive();
        boolean bl = childPopupInactive = !JBPopupFactory.getInstance().isChildPopupFocused((Component)this.myPanel);
        if (nodePopupInactive && childPopupInactive && opposite != null && opposite != this.myPanel && !this.myPanel.isAncestorOf(opposite) && !e.isTemporary()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
        }
        this.myPanel.updateItems();
    }

    private void rebuildUI() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getUpdateQueue().queueRebuildUi();
        }
    }

    private void updateModel() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getModel().setChanged(true);
            this.myPanel.getUpdateQueue().queueModelUpdateFromFocus();
        }
    }

    public void fileStatusesChanged() {
        this.rebuildUI();
    }

    public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/navigationToolbar/NavBarListener", "fileStatusChanged"));
        }
        this.rebuildUI();
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "childAdded"));
        }
        this.updateModel();
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "childReplaced"));
        }
        this.updateModel();
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "childMoved"));
        }
        this.updateModel();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "childrenChanged"));
        }
        this.updateModel();
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "propertyChanged"));
        }
        this.updateModel();
    }

    public void rootsChanged(ModuleRootEvent event) {
        this.updateModel();
    }

    public void problemsAppeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/navigationToolbar/NavBarListener", "problemsAppeared"));
        }
        this.updateModel();
    }

    public void problemsDisappeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/navigationToolbar/NavBarListener", "problemsDisappeared"));
        }
        this.updateModel();
    }

    @Override
    public void modelChanged() {
        this.rebuildUI();
    }

    @Override
    public void selectionChanged() {
        this.myPanel.updateItems();
        this.myPanel.scrollSelectionToVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name2;
        if (this.myPanel.isShowing() && ("focusOwner".equals(name2 = evt.getPropertyName()) || "permanentFocusOwner".equals(name2))) {
            this.myPanel.getUpdateQueue().restartRebuild();
        }
    }

    public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        if (NavBarListener.shouldSkipAction(action)) {
            return;
        }
        if (this.myPanel.isInFloatingMode()) {
            this.myPanel.hideHint();
        } else {
            this.myPanel.cancelPopup();
        }
    }

    private static boolean shouldSkipAction(AnAction action) {
        return action instanceof PopupAction || action instanceof CopyAction || action instanceof CutAction || action instanceof ScrollingUtil.ScrollingAction;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!(e.isAltDown() || e.isMetaDown() || e.isControlDown() || this.myPanel.isNodePopupActive())) {
            if (!Character.isLetter(e.getKeyChar())) {
                return;
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myPanel.getProject());
            ActionCallback firstCharTyped = new ActionCallback();
            focusManager.typeAheadUntil(firstCharTyped);
            this.myPanel.moveDown();
            SwingUtilities.invokeLater(() -> {
                try {
                    Robot robot = new Robot();
                    boolean shiftOn = e.isShiftDown();
                    int code2 = e.getKeyCode();
                    if (shiftOn) {
                        robot.keyPress(16);
                    }
                    robot.keyPress(code2);
                    robot.keyRelease(code2);
                    firstCharTyped.setDone();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            });
        }
    }

    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/navigationToolbar/NavBarListener", "fileOpened"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/navigationToolbar/NavBarListener", "fileOpened"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/navigationToolbar/NavBarListener", "lambda$fileOpened$2"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/navigationToolbar/NavBarListener", "lambda$fileOpened$2"));
            }
            if (this.myPanel.hasFocus()) {
                manager.openFile(file2, true);
            }
        });
    }

    public void lookAndFeelChanged(LafManager source) {
        this.myPanel.getNavBarUI().clearItems();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
    }

    public void beforeEditorTyping(char c, DataContext dataContext) {
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "beforeChildAddition"));
        }
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "beforeChildRemoval"));
        }
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "beforeChildReplacement"));
        }
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "beforeChildMovement"));
        }
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "beforeChildrenChange"));
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "beforePropertyChange"));
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/navigationToolbar/NavBarListener", "childRemoved"));
        }
    }
}

