/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class DirectoryUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "directory";

    public DirectoryUrl(String url, String moduleName) {
        super(url, moduleName, ELEMENT_TYPE);
    }

    public static DirectoryUrl create(PsiDirectory directory) {
        Project project2 = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project2);
        return new DirectoryUrl(virtualFile.getUrl(), module2 != null ? module2.getName() : null);
    }

    @Override
    public Object[] createPath(Project project2) {
        Module module2;
        if (this.moduleName != null && (module2 = (Module)ReadAction.compute(() -> ModuleManager.getInstance((Project)project2).findModuleByName(this.moduleName))) == null) {
            return null;
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile file2 = virtualFileManager.findFileByUrl(this.url);
        if (file2 == null) {
            return null;
        }
        PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)project2).findDirectory(file2));
        if (directory == null) {
            return null;
        }
        return new Object[]{directory};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new DirectoryUrl(url, moduleName);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element) {
        if (element instanceof PsiDirectory) {
            return DirectoryUrl.create((PsiDirectory)element);
        }
        return null;
    }
}

