/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewModuleGroupNode
extends ModuleGroupNode {
    public ProjectViewModuleGroupNode(Project project2, Object value2, ViewSettings viewSettings) {
        super(project2, (ModuleGroup)value2, viewSettings);
    }

    public ProjectViewModuleGroupNode(Project project2, ModuleGroup value2, ViewSettings viewSettings) {
        super(project2, value2, viewSettings);
    }

    @Override
    protected AbstractTreeNode createModuleNode(Module module2) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PsiDirectory psi;
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (roots.length == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots[0])) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewModuleNode(this.getProject(), module2, this.getSettings());
    }

    @Override
    protected ModuleGroupNode createModuleGroupNode(ModuleGroup moduleGroup) {
        return new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    @Override
    @NotNull
    protected List<Module> getModulesByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/ProjectViewModuleGroupNode", "getModulesByFile"));
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file2, false));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ProjectViewModuleGroupNode", "getModulesByFile"));
        }
        return list2;
    }
}

