/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootType {
    public static final ExtensionPointName<RootType> ROOT_EP = ExtensionPointName.create((String)"com.intellij.scratch.rootType");
    private final String myId;
    private final String myDisplayName;

    @NotNull
    public static RootType[] getAllRootIds() {
        RootType[] rootTypeArray = (RootType[])Extensions.getExtensions(ROOT_EP);
        if (rootTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "getAllRootIds"));
        }
        return rootTypeArray;
    }

    @NotNull
    public static RootType findById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/scratch/RootType", "findById"));
        }
        for (RootType type2 : RootType.getAllRootIds()) {
            if (!id.equals(type2.getId())) continue;
            RootType rootType = type2;
            if (rootType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "findById"));
            }
            return rootType;
        }
        throw new AssertionError((Object)id);
    }

    @NotNull
    public static <T extends RootType> T findByClass(Class<T> aClass) {
        RootType rootType = (RootType)Extensions.findExtension(ROOT_EP, aClass);
        if (rootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "findByClass"));
        }
        return (T)rootType;
    }

    protected RootType(@NotNull String id, @Nullable String displayName) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/scratch/RootType", "<init>"));
        }
        this.myId = id;
        this.myDisplayName = displayName;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "getId"));
        }
        return string;
    }

    @Nullable
    public final String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isHidden() {
        return StringUtil.isEmpty((String)this.myDisplayName);
    }

    public boolean containsFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        ScratchFileService service = ScratchFileService.getInstance();
        return service != null && service.getRootType(file2) == this;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "substituteLanguage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "substituteLanguage"));
        }
        return null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "substituteIcon"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "substituteIcon"));
        }
        Language language = this.substituteLanguage(project2, file2);
        FileType fileType = LanguageUtil.getLanguageFileType((Language)language);
        if (fileType == null) {
            fileType = ScratchUtil.getFileTypeFromName(file2);
        }
        return fileType != null ? fileType.getIcon() : null;
    }

    @Nullable
    public String substituteName(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "substituteName"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "substituteName"));
        }
        return null;
    }

    public VirtualFile findFile(@Nullable Project project2, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        if (pathName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/intellij/ide/scratch/RootType", "findFile"));
        }
        return ScratchFileService.getInstance().findFile(this, pathName, option);
    }

    public void fileOpened(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "fileOpened"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/RootType", "fileOpened"));
        }
    }

    public void fileClosed(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "fileClosed"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/RootType", "fileClosed"));
        }
    }

    public boolean isIgnored(@NotNull Project project2, @NotNull VirtualFile element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "isIgnored"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/RootType", "isIgnored"));
        }
        return false;
    }

    public void registerTreeUpdater(@NotNull Project project2, @NotNull Disposable disposable, @NotNull Runnable onUpdate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "registerTreeUpdater"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/ide/scratch/RootType", "registerTreeUpdater"));
        }
        if (onUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onUpdate", "com/intellij/ide/scratch/RootType", "registerTreeUpdater"));
        }
    }
}

