/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;

public class IDE {
    public final Application application;
    public final Project project;
    private final Map<Object, Object> bindings;
    private final IdeScriptEngine myEngine;

    public IDE(@Nullable Project project2, @NotNull IdeScriptEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ide/script/IDE", "<init>"));
        }
        this.application = ApplicationManager.getApplication();
        this.bindings = ContainerUtil.newConcurrentMap();
        this.project = project2;
        this.myEngine = engine;
    }

    public void print(Object o) {
        IDE.print(this.myEngine.getStdOut(), o);
    }

    public void error(Object o) {
        IDE.print(this.myEngine.getStdErr(), o);
    }

    public Object put(Object key2, Object value2) {
        return value2 == null ? this.bindings.remove(key2) : this.bindings.put(key2, value2);
    }

    public Object get(Object key2) {
        return this.bindings.get(key2);
    }

    private static void print(Writer writer, Object o) {
        try {
            writer.append(String.valueOf(o)).append("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

