/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.util.PsiLambdaNameHelper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaLambdaTreeElement
extends JavaClassTreeElementBase<PsiLambdaExpression> {
    public static final JavaLambdaTreeElement[] EMPTY_ARRAY = new JavaLambdaTreeElement[0];
    private String myName;
    private String myFunctionalName;

    public JavaLambdaTreeElement(PsiLambdaExpression lambdaExpression) {
        super(false, lambdaExpression);
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    public String getPresentableText() {
        if (this.myName != null) {
            return this.myName;
        }
        PsiLambdaExpression element = (PsiLambdaExpression)this.getElement();
        if (element != null) {
            this.myName = PsiLambdaNameHelper.getVMName((PsiLambdaExpression)element);
            return this.myName;
        }
        return "Lambda";
    }

    @Override
    public boolean isSearchInLocationString() {
        return true;
    }

    @Override
    public String getLocationString() {
        PsiType interfaceType;
        PsiLambdaExpression lambdaExpression;
        if (this.myFunctionalName == null && (lambdaExpression = (PsiLambdaExpression)this.getElement()) != null && !DumbService.isDumb((Project)lambdaExpression.getProject()) && (interfaceType = lambdaExpression.getFunctionalInterfaceType()) != null) {
            this.myFunctionalName = interfaceType.getPresentableText();
        }
        return this.myFunctionalName;
    }

    @Override
    public String toString() {
        return super.toString() + (this.myFunctionalName == null ? "" : " (" + this.getLocationString() + ")");
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaTreeElement", "getChildrenBase"));
        }
        return list2;
    }

    @Override
    public Icon getIcon(boolean open2) {
        return AllIcons.Nodes.Function;
    }
}

