/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.AbstractXmlTagTreeElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagTreeElement
extends AbstractXmlTagTreeElement<XmlTag> {
    @NonNls
    private static final String ID_ATTR_NAME = "id";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";

    public XmlTagTreeElement(XmlTag tag) {
        super(tag);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = XmlTagTreeElement.getStructureViewTreeElements(((XmlTag)this.getElement()).getSubTags());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/XmlTagTreeElement", "getChildrenBase"));
        }
        return collection;
    }

    public String getPresentableText() {
        XmlTag element = (XmlTag)this.getElement();
        if (element == null) {
            return IdeBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
        }
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null) {
            id = element.getAttributeValue(NAME_ATTR_NAME);
        }
        return (id = XmlTagTreeElement.toCanonicalForm(id)) != null ? id + ':' + element.getLocalName() : element.getName();
    }

    @Override
    public String getLocationString() {
        StringBuilder buffer = new StringBuilder();
        XmlTag element = (XmlTag)this.getElement();
        assert (element != null);
        String id = element.getAttributeValue(ID_ATTR_NAME);
        String usedAttrName = null;
        if (id == null) {
            id = element.getAttributeValue(NAME_ATTR_NAME);
            if (id != null) {
                usedAttrName = NAME_ATTR_NAME;
            }
        } else {
            usedAttrName = ID_ATTR_NAME;
        }
        id = XmlTagTreeElement.toCanonicalForm(id);
        for (XmlAttribute attribute : element.getAttributes()) {
            if (buffer.length() != 0) {
                buffer.append(' ');
            }
            String name2 = attribute.getName();
            if (usedAttrName != null && id != null && usedAttrName.equals(name2)) continue;
            buffer.append(name2);
            buffer.append('=').append('\"').append(attribute.getValue()).append('\"');
        }
        return buffer.toString();
    }

    @Nullable
    public static String toCanonicalForm(@Nullable String id) {
        if (id != null && (id = id.trim()).isEmpty()) {
            return null;
        }
        return id;
    }
}

