/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class StructureTreeBuilder
extends AbstractTreeBuilder {
    private final Project myProject;
    private final StructureViewModel myStructureModel;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);

    public StructureTreeBuilder(Project project2, JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, StructureViewModel structureModel) {
        super(tree, treeModel, treeStructure, null, false);
        this.myProject = project2;
        this.myStructureModel = structureModel;
        final ModelListener myModelListener = new ModelListener(){

            public void onModelChanged() {
                StructureTreeBuilder.this.addRootToUpdate();
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener(), (Disposable)this);
        CopyPasteUtil.DefaultCopyPasteListener copyPasteListener = new CopyPasteUtil.DefaultCopyPasteListener(this.getUpdater());
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)copyPasteListener, (Disposable)this);
        this.initRootNode();
        this.myStructureModel.addModelListener(myModelListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                StructureTreeBuilder.this.myStructureModel.removeModelListener(myModelListener);
            }
        });
        this.setCanYieldUpdate(!ApplicationManager.getApplication().isUnitTestMode());
    }

    protected final boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((AbstractTreeNode)nodeDescriptor).isAlwaysShowPlus();
    }

    protected final boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        NodeDescriptor parent;
        StructureViewModel model = this.myStructureModel;
        if (model instanceof TreeModelWrapper) {
            model = ((TreeModelWrapper)model).getModel();
        }
        if (model instanceof StructureViewModel.ExpandInfoProvider) {
            StructureViewModel.ExpandInfoProvider provider = (StructureViewModel.ExpandInfoProvider)model;
            Object element = nodeDescriptor.getElement();
            if (element instanceof StructureViewComponent.StructureViewTreeElementWrapper) {
                StructureViewTreeElement value2;
                StructureViewComponent.StructureViewTreeElementWrapper wrapper = (StructureViewComponent.StructureViewTreeElementWrapper)((Object)element);
                if (wrapper.getValue() instanceof StructureViewTreeElement && (value2 = (StructureViewTreeElement)wrapper.getValue()) != null) {
                    return provider.isAutoExpand(value2);
                }
            } else if (element instanceof GroupWrapper) {
                Group group = (Group)((GroupWrapper)((Object)element)).getValue();
                for (TreeElement treeElement : group.getChildren()) {
                    if (!(treeElement instanceof StructureViewTreeElement) || provider.isAutoExpand((StructureViewTreeElement)treeElement)) continue;
                    return false;
                }
            }
        }
        return super.isAutoExpandNode((parent = nodeDescriptor.getParentDescriptor()) == null ? nodeDescriptor : parent);
    }

    protected final boolean isSmartExpand() {
        StructureViewModel model = this.myStructureModel;
        if (model instanceof TreeModelWrapper) {
            model = ((TreeModelWrapper)model).getModel();
        }
        if (model instanceof StructureViewModel.ExpandInfoProvider) {
            return ((StructureViewModel.ExpandInfoProvider)model).isSmartExpand();
        }
        return false;
    }

    @NotNull
    protected final ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder", "createProgressIndicator"));
        }
        return statusBarProgress;
    }

    private void setupUpdateAlarm() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            if (!this.isDisposed() && !this.myProject.isDisposed()) {
                this.addRootToUpdate();
            }
        }, 300, ModalityState.stateForComponent((Component)this.getTree()));
    }

    final void addRootToUpdate() {
        AbstractTreeStructure structure = this.getTreeStructure();
        structure.asyncCommit().doWhenDone(() -> {
            ((SmartTreeStructure)structure).rebuildTree();
            if (!this.isDisposed()) {
                this.getUpdater().addSubtreeToUpdate(this.getRootNode());
            }
        });
    }

    @NotNull
    protected final AbstractTreeNode createSearchingTreeNodeWrapper() {
        StructureViewComponent.StructureViewTreeElementWrapper structureViewTreeElementWrapper = new StructureViewComponent.StructureViewTreeElementWrapper(null, null, null);
        if (structureViewTreeElementWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder", "createSearchingTreeNodeWrapper"));
        }
        return structureViewTreeElementWrapper;
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private final PsiModificationTracker myModificationTracker;
        private long myOutOfCodeBlockModificationCount;

        private MyPsiTreeChangeListener() {
            this.myModificationTracker = PsiManager.getInstance((Project)StructureTreeBuilder.this.myProject).getModificationTracker();
            this.myOutOfCodeBlockModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder$MyPsiTreeChangeListener", "childRemoved"));
            }
            PsiElement child = event.getOldChild();
            if (child instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder$MyPsiTreeChangeListener", "childAdded"));
            }
            PsiElement child = event.getNewChild();
            if (child instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder$MyPsiTreeChangeListener", "childReplaced"));
            }
            PsiElement oldChild = event.getOldChild();
            PsiElement newChild = event.getNewChild();
            if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder$MyPsiTreeChangeListener", "childMoved"));
            }
            this.childrenChanged();
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder$MyPsiTreeChangeListener", "childrenChanged"));
            }
            this.childrenChanged();
        }

        private void childrenChanged() {
            long newModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
            if (newModificationCount == this.myOutOfCodeBlockModificationCount) {
                return;
            }
            this.myOutOfCodeBlockModificationCount = newModificationCount;
            StructureTreeBuilder.this.setupUpdateAlarm();
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/structureView/newStructureView/StructureTreeBuilder$MyPsiTreeChangeListener", "propertyChanged"));
            }
            this.childrenChanged();
        }
    }
}

