/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.ui.RegistryTextOptionDescriptor;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project2) {
        List list2 = Holder.ourValues;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/RegistryOptionsTopHitProvider", "getOptions"));
        }
        return list2;
    }

    @Override
    public boolean isEnabled(@Nullable Project project2) {
        return ApplicationManager.getApplication().isInternal();
    }

    @Override
    public String getId() {
        return "registry";
    }

    private static class Holder {
        private static final List<OptionDescription> ourValues = Holder.initValues();

        private Holder() {
        }

        private static List<OptionDescription> initValues() {
            ArrayList<OptionDescription> result2 = new ArrayList<OptionDescription>();
            for (RegistryValue value2 : Registry.getAll()) {
                if (value2.isBoolean()) {
                    String key2 = value2.getKey();
                    RegistryBooleanOptionDescriptor optionDescriptor = new RegistryBooleanOptionDescriptor(key2, key2);
                    if (value2.isChangedFromDefault()) {
                        result2.add(0, (OptionDescription)optionDescriptor);
                        continue;
                    }
                    result2.add((OptionDescription)optionDescriptor);
                    continue;
                }
                result2.add(new RegistryTextOptionDescriptor(value2));
            }
            return result2;
        }
    }
}

