/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    protected String getPrefix() {
        return UIUtil.isUnderWin10LookAndFeel() ? "intellijlaf_native" : "intellijlaf";
    }

    @Override
    protected BasicLookAndFeel createBaseLookAndFeel() {
        Registry.get((String)"ide.intellij.laf.win10.ui").addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(RegistryValue value2) {
                try {
                    UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
            }
        }, this.myDisposable);
        if (UIUtil.isUnderWindowsLookAndFeel()) {
            try {
                String name2 = UIManager.getSystemLookAndFeelClassName();
                return (BasicLookAndFeel)Class.forName(name2).newInstance();
            }
            catch (Exception e) {
                IntelliJLaf.log(e);
            }
        }
        return super.createBaseLookAndFeel();
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    public static boolean isGraphite() {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            return Foundation.invoke((String)"NSColor", (String)"currentControlTint", (Object[])new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Color getSelectedControlColor() {
        return MacUtil.colorFromNative((ID)Foundation.invoke((String)"NSColor", (String)"alternateSelectedControlColor", (Object[])new Object[0]));
    }
}

