/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class DarculaUIUtil {
    private static final Color GLOW_COLOR = new JBColor(new Color(31, 121, 212), new Color(96, 175, 255));
    private static final Color MAC_ACTIVE_ERROR_COLOR = new Color(-2131412165, true);
    private static final JBColor DEFAULT_ACTIVE_ERROR_COLOR = new JBColor(15023693, 9124924);
    private static final Color MAC_INACTIVE_ERROR_COLOR = new Color(-2131247940, true);
    private static final JBColor DEFAULT_INACTIVE_ERROR_COLOR = new JBColor(0xEBBCBC, 0x725252);
    private static final Color ACTIVE_ERROR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_ACTIVE_ERROR_COLOR : DEFAULT_ACTIVE_ERROR_COLOR);
    private static final Color INACTIVE_ERROR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_INACTIVE_ERROR_COLOR : DEFAULT_INACTIVE_ERROR_COLOR);
    private static final Color MAC_REGULAR_COLOR = new Color(-2142790404, true);
    private static final Color MAC_GRAPHITE_COLOR = new Color(-2137417827, true);

    public static void paintFocusRing(Graphics g, Rectangle bounds) {
        MacUIUtil.paintFocusRing((Graphics2D)((Graphics2D)g), (Color)GLOW_COLOR, (Rectangle)bounds);
    }

    public static void paintFocusOval(Graphics g, int x, int y, int width, int height) {
        MacUIUtil.paintFocusRing((Graphics2D)((Graphics2D)g), (Color)GLOW_COLOR, (Rectangle)new Rectangle(x, y, width, height), (boolean)true);
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds, Component component) {
        DarculaUIUtil.paintSearchFocusRing(g, bounds, component, -1);
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds, Component component, int maxArcSize) {
        int correction = UIUtil.isUnderAquaLookAndFeel() ? 30 : (UIUtil.isUnderDarcula() ? 50 : 0);
        Color[] colors = new Color[]{ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(180 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(120 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(70 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(100 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(50 - correction))};
        Object oldAntialiasingValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        int arcSize = r.height - 1;
        if (maxArcSize > 0) {
            arcSize = Math.min(maxArcSize, arcSize);
        }
        if (arcSize % 2 == 1) {
            --arcSize;
        }
        g.setColor(component.getBackground());
        g.fillRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, arcSize - 4, arcSize - 4);
        g.setColor(colors[0]);
        g.drawRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, arcSize - 4, arcSize - 4);
        g.setColor(colors[1]);
        g.drawRoundRect(r.x + 1, r.y + 1, r.width - 3, r.height - 3, arcSize - 2, arcSize - 2);
        g.setColor(colors[2]);
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, arcSize, arcSize);
        g.setColor(colors[3]);
        g.drawRoundRect(r.x + 3, r.y + 3, r.width - 7, r.height - 7, arcSize - 6, arcSize - 6);
        g.setColor(colors[4]);
        g.drawRoundRect(r.x + 4, r.y + 4, r.width - 9, r.height - 9, arcSize - 8, arcSize - 8);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    public static void paintErrorBorder(Graphics2D g, int width, int height, int arc, boolean symmetric, boolean hasFocus) {
        g.setPaint(hasFocus ? ACTIVE_ERROR_COLOR : INACTIVE_ERROR_COLOR);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, int arc, boolean symmetric) {
        g.setPaint(IntelliJLaf.isGraphite() ? MAC_GRAPHITE_COLOR : MAC_REGULAR_COLOR);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    private static void doPaint(Graphics2D g, int width, int height, int arc, boolean symmetric) {
        double bw = UIUtil.isUnderDefaultMacTheme() ? (UIUtil.isRetina((Graphics2D)g) ? 0.5 : 1.0) : 0.0;
        double lw = JBUI.scale((int)(UIUtil.isUnderDefaultMacTheme() ? 3 : 2));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        double outerArc = arc > 0 ? (double)arc + lw - (double)JBUI.scale((int)2) : lw;
        double rightOuterArc = symmetric ? outerArc : (double)JBUI.scale((int)6);
        Path2D.Double outerRect = new Path2D.Double(0);
        ((Path2D)outerRect).moveTo((double)width - rightOuterArc, 0.0);
        ((Path2D)outerRect).quadTo(width, 0.0, width, rightOuterArc);
        ((Path2D)outerRect).lineTo(width, (double)height - rightOuterArc);
        ((Path2D)outerRect).quadTo(width, height, (double)width - rightOuterArc, height);
        ((Path2D)outerRect).lineTo(outerArc, height);
        ((Path2D)outerRect).quadTo(0.0, height, 0.0, (double)height - outerArc);
        ((Path2D)outerRect).lineTo(0.0, outerArc);
        ((Path2D)outerRect).quadTo(0.0, 0.0, outerArc, 0.0);
        outerRect.closePath();
        double rightInnerArc = symmetric ? outerArc : (double)JBUI.scale((int)7);
        Path2D.Double innerRect = new Path2D.Double(0);
        ((Path2D)innerRect).moveTo((double)width - rightInnerArc, lw += bw);
        ((Path2D)innerRect).quadTo((double)width - lw, lw, (double)width - lw, rightInnerArc);
        ((Path2D)innerRect).lineTo((double)width - lw, (double)height - rightInnerArc);
        ((Path2D)innerRect).quadTo((double)width - lw, (double)height - lw, (double)width - rightInnerArc, (double)height - lw);
        ((Path2D)innerRect).lineTo(outerArc, (double)height - lw);
        ((Path2D)innerRect).quadTo(lw, (double)height - lw, lw, (double)height - outerArc);
        ((Path2D)innerRect).lineTo(lw, outerArc);
        ((Path2D)innerRect).quadTo(lw, lw, outerArc, lw);
        innerRect.closePath();
        Path2D.Double path = new Path2D.Double(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
    }

    public static boolean isCurrentEventShiftDownEvent() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        return event instanceof KeyEvent && ((KeyEvent)event).isShiftDown();
    }

    public static int getPatchedNextVisualPositionFrom(JTextComponent t, int pos, int direction) {
        if (!DarculaUIUtil.isCurrentEventShiftDownEvent()) {
            if (direction == 7 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionEnd() == pos) {
                return t.getSelectionStart();
            }
            if (direction == 3 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionStart() == pos) {
                return t.getSelectionEnd();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasFocus(@NotNull Component component) {
        List<Component> children2;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/ui/laf/darcula/DarculaUIUtil", "hasFocus"));
        }
        if (component.hasFocus()) {
            return true;
        }
        if (!(component instanceof JComponent)) {
            return false;
        }
        Iterator<Component> iterator = component.getTreeLock();
        synchronized (iterator) {
            children2 = Arrays.asList(((Container)component).getComponents());
        }
        for (Component c : children2) {
            if (!DarculaUIUtil.hasFocus(c)) continue;
            return true;
        }
        return false;
    }

    public static class MouseHoverPropertyTrigger
    extends MouseAdapter {
        private final JComponent repaintComponent;
        private final String hoverProperty;

        public MouseHoverPropertyTrigger(@NotNull JComponent repaintComponent, @NotNull String hoverProperty) {
            if (repaintComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repaintComponent", "com/intellij/ide/ui/laf/darcula/DarculaUIUtil$MouseHoverPropertyTrigger", "<init>"));
            }
            if (hoverProperty == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hoverProperty", "com/intellij/ide/ui/laf/darcula/DarculaUIUtil$MouseHoverPropertyTrigger", "<init>"));
            }
            this.repaintComponent = repaintComponent;
            this.hoverProperty = hoverProperty;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent c = (JComponent)e.getComponent();
            c.putClientProperty(this.hoverProperty, Boolean.TRUE);
            this.repaintComponent.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JComponent c = (JComponent)e.getComponent();
            c.putClientProperty(this.hoverProperty, Boolean.FALSE);
            this.repaintComponent.repaint();
        }
    }

    public static class WinEditorTextFieldBorder
    extends DarculaEditorTextFieldBorder {
        private final JComponent editorComponent;

        public WinEditorTextFieldBorder(final EditorTextField editorTextField, EditorEx editor) {
            super(editorTextField, editor);
            this.editorComponent = editor.getComponent();
            editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

                public void mouseEntered(EditorMouseEvent e) {
                    JComponent c = e.getEditor().getComponent();
                    c.putClientProperty("JTextField.hover", Boolean.TRUE);
                    editorTextField.repaint();
                }

                public void mouseExited(EditorMouseEvent e) {
                    JComponent c = e.getEditor().getComponent();
                    c.putClientProperty("JTextField.hover", Boolean.FALSE);
                    editorTextField.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (WinEditorTextFieldBorder.isComboBoxEditor(c)) {
                g.setColor(c.getBackground());
                g.fillRect(x, y, width, height);
                return;
            }
            if (UIUtil.getParentOfType(EditorTextField.class, (Component)c) == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Rectangle innerRect;
                Rectangle r = new Rectangle(x, y, width, height);
                if (UIUtil.getParentOfType(Wrapper.class, (Component)c) != null && TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c)) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2, (int)0));
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                if (this.isBorderOpaque() || c.getParent() != null) {
                    g2.setColor(c.getParent().getBackground());
                    Path2D.Double borderArea = new Path2D.Double(0);
                    borderArea.append(r, false);
                    innerRect = new Rectangle(r);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)2));
                    borderArea.append(innerRect, false);
                    g2.fill(borderArea);
                }
                if (DarculaUIUtil.hasFocus(this.editorTextField)) {
                    g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                } else if (this.editorTextField.isEnabled() && this.editorComponent != null && this.editorComponent.getClientProperty("JTextField.hover") == Boolean.TRUE) {
                    g2.setColor(UIManager.getColor("TextField.hoverBorderColor"));
                } else {
                    g2.setColor(UIManager.getColor("TextField.borderColor"));
                }
                if (!this.editorTextField.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                Path2D.Double border = new Path2D.Double(0);
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                border.append(r, false);
                innerRect = new Rectangle(r);
                JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)1));
                border.append(innerRect, false);
                g2.fill(border);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (UIUtil.getParentOfType(ComboBoxCompositeEditor.class, (Component)c) != null) {
                return JBUI.emptyInsets().asUIResource();
            }
            return WinEditorTextFieldBorder.isComboBoxEditor(c) ? JBUI.insets((int)1, (int)6).asUIResource() : JBUI.insets((int)4, (int)6).asUIResource();
        }
    }

    public static class MacEditorTextFieldBorder
    extends DarculaEditorTextFieldBorder {
        public MacEditorTextFieldBorder(EditorTextField editorTextField, EditorEx editor) {
            super(editorTextField, editor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (MacEditorTextFieldBorder.isComboBoxEditor(c)) {
                g.setColor(c.getBackground());
                g.fillRect(x, y, width, height);
                return;
            }
            if (UIUtil.getParentOfType(EditorTextField.class, (Component)c) == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                if (c.isOpaque() || c instanceof JComponent && ((JComponent)c).getClientProperty("MAC_FILL_BORDER") == Boolean.TRUE) {
                    g2.setColor(UIUtil.getPanelBackground());
                    g2.fillRect(x, y, width, height);
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(x + JBUI.scale((int)3), y + JBUI.scale((int)3), width - JBUI.scale((int)6), height - JBUI.scale((int)6));
                g2.setColor(c.getBackground());
                g2.fill(rect);
                if (!this.editorTextField.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                }
                double bw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
                Path2D.Double outline = new Path2D.Double(0);
                outline.append(rect, false);
                outline.append(new Rectangle2D.Double(((RectangularShape)rect).getX() + bw, ((RectangularShape)rect).getY() + bw, ((RectangularShape)rect).getWidth() - 2.0 * bw, ((RectangularShape)rect).getHeight() - 2.0 * bw), false);
                g2.setColor((Color)Gray.xBC);
                g2.fill(outline);
                if (this.editorTextField.isEnabled() && this.editorTextField.isVisible() && DarculaUIUtil.hasFocus(this.editorTextField)) {
                    g2.translate(x, y);
                    DarculaUIUtil.paintFocusBorder(g2, width, height, 0, true);
                }
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return MacEditorTextFieldBorder.isComboBoxEditor(c) ? new InsetsUIResource(1, 3, 2, 3) : new InsetsUIResource(6, 7, 6, 7);
        }
    }
}

