/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import sun.swing.SwingUtilities2;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    protected volatile int offset = 0;

    public static ComponentUI createUI(JComponent c) {
        c.setBorder((Border)JBUI.Borders.empty().asUIResource());
        return new DarculaProgressBarUI();
    }

    @Override
    protected void paintIndeterminate(Graphics g2d, JComponent c) {
        if (!(g2d instanceof Graphics2D)) {
            return;
        }
        Graphics2D g = (Graphics2D)g2d;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        g.setColor((Color)new JBColor((Color)Gray._240, (Color)Gray._128));
        int w = c.getWidth();
        int h = c.getPreferredSize().height;
        if (!DarculaProgressBarUI.isEven(c.getHeight() - h)) {
            ++h;
        }
        if (c.isOpaque()) {
            g.fillRect(0, (c.getHeight() - h) / 2, w, h);
        }
        g.setColor((Color)new JBColor((Color)Gray._165, (Color)Gray._88));
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        g.translate(0, (c.getHeight() - h) / 2);
        float R = JBUI.scale((float)8.0f);
        float R2 = JBUI.scale((float)9.0f);
        float off = JBUI.scale((float)1.0f);
        Area innerBorderRoundRect = new Area(new RoundRectangle2D.Float(off, off, (float)w - 2.0f * off, (float)h - 2.0f * off, R, R));
        Area containingRoundRect = new Area(new RoundRectangle2D.Float(2.0f * off, 2.0f * off, (float)w - 4.0f * off, (float)h - 4.0f * off, R, R));
        for (int x = -this.offset; x < Math.max(c.getWidth(), c.getHeight()); x += this.getPeriodLength()) {
            Path2D.Double path = new Path2D.Double();
            float ww = (float)this.getPeriodLength() / 2.0f;
            path.moveTo(x, 0.0);
            path.lineTo((float)x + ww, 0.0);
            path.lineTo((float)x + ww - (float)(h / 2), h);
            path.lineTo(x - h / 2, h);
            path.lineTo(x, 0.0);
            path.closePath();
            Area area = new Area(path);
            area.intersect(containingRoundRect);
            g.fill(area);
        }
        this.offset = (this.offset + 1) % this.getPeriodLength();
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        area.subtract(innerBorderRoundRect);
        g.setColor((Color)Gray._128);
        if (c.isOpaque()) {
            g.fill(area);
        }
        area.subtract(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, R2, R2)));
        g.setColor(c.getParent().getBackground());
        if (c.isOpaque()) {
            g.fill(area);
        }
        Area insetArea = new Area(innerBorderRoundRect);
        insetArea.subtract(containingRoundRect);
        g.fill(insetArea);
        g.translate(0, -(c.getHeight() - h) / 2);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString((Graphics)g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width);
            } else {
                this.paintString((Graphics)g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height);
            }
        }
        config.restore();
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !c.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(g, c);
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth();
        int h = this.progressBar.getPreferredSize().height;
        if (!DarculaProgressBarUI.isEven(c.getHeight() - h)) {
            ++h;
        }
        int barRectWidth = w - (b.right + b.left);
        int barRectHeight = h - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        g.setColor(c.getParent().getBackground());
        Graphics2D g2 = (Graphics2D)g;
        if (c.isOpaque()) {
            g.fillRect(0, 0, w, h);
        }
        float R = JBUI.scale((float)8.0f);
        float R2 = JBUI.scale((float)9.0f);
        float off = JBUI.scale((float)1.0f);
        g2.translate(0, (c.getHeight() - h) / 2);
        g2.setColor(this.progressBar.getForeground());
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, (float)w - off, (float)h - off, R2, R2));
        g2.setColor(c.getParent().getBackground());
        g2.fill(new RoundRectangle2D.Float(off, off, (float)w - 2.0f * off - off, (float)h - 2.0f * off - off, R, R));
        g2.setColor(this.progressBar.getForeground());
        g2.fill(new RoundRectangle2D.Float(2.0f * off, 2.0f * off, (float)amountFull - JBUI.scale((float)5.0f), (float)h - JBUI.scale((float)5.0f), JBUI.scale((float)7.0f), JBUI.scale((float)7.0f)));
        g2.translate(0, -(c.getHeight() - h) / 2);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
        config.restore();
    }

    private void paintString(Graphics g, int x, int y, int w, int h, int fillStart, int amountFull) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, w, h);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, h);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, w, h);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, w, amountFull);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    protected int getPeriodLength() {
        return JBUI.scale((int)16);
    }

    private static boolean isEven(int value2) {
        return value2 % 2 == 0;
    }
}

