/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JSpinner spinner = (JSpinner)c;
        JFormattedTextField editor = (JFormattedTextField)UIUtil.findComponentOfType((JComponent)spinner, JFormattedTextField.class);
        int x1 = x + 1;
        int y1 = y + 3;
        int width1 = width - 2;
        int height1 = height - 6;
        boolean focused = c.isEnabled() && c.isVisible() && editor != null && editor.hasFocus();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        if (c.isOpaque()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(x, y, width, height);
        }
        g.setColor(UIUtil.getTextFieldBackground());
        g.fillRoundRect(x1, y1, width1, height1, 5, 5);
        g.setColor(UIManager.getColor(spinner.isEnabled() ? "Spinner.darcula.enabledButtonColor" : "Spinner.darcula.disabledButtonColor"));
        if (editor != null) {
            int off = editor.getBounds().x + editor.getWidth() + ((JSpinner)c).getInsets().left + 1;
            Area rect = new Area(new RoundRectangle2D.Double(x1, y1, width1, height1, 5.0, 5.0));
            Area blueRect = new Area(new Rectangle(off, y1, 22, height1));
            rect.intersect(blueRect);
            ((Graphics2D)g).fill(rect);
            if (UIUtil.isUnderDarcula()) {
                g.setColor((Color)Gray._100);
                g.drawLine(off, y1, off, height1 + 2);
            }
        }
        if (!c.isEnabled()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (focused) {
            DarculaUIUtil.paintFocusRing(g, new Rectangle(x1 + 2, y1, width1 - 3, height1));
        } else {
            g.setColor((Color)new JBColor((Color)Gray._149, (Color)Gray._100));
            g.drawRoundRect(x1, y1, width1, height1, 5, 5);
        }
        config.restore();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(5, 7, 5, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFocused(Component c) {
        JSpinner spinner;
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof JSpinner && (spinner = (JSpinner)c).getEditor() != null) {
            Object object = spinner.getEditor().getTreeLock();
            synchronized (object) {
                return spinner.getEditor().getComponent(0).hasFocus();
            }
        }
        return false;
    }
}

