/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextFieldUI;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorPanel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class WinIntelliJTextBorder
extends DarculaTextBorder {
    @Override
    public Insets getBorderInsets(Component c) {
        if (TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c)) {
            return JBUI.insets((int)4, (int)27, (int)4, (int)24).asUIResource();
        }
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return JBUI.insets((int)4, (int)21, (int)4, (int)24).asUIResource();
        }
        if (c instanceof JTextField && c.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        return JBUI.insets((int)4, (int)5).asUIResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Rectangle r = new Rectangle(x, y, width, height);
            WinIntelliJTextFieldUI.adjustInWrapperRect(r, c);
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            Object eop = ((JComponent)c).getClientProperty("JComponent.error.outline");
            if (Registry.is((String)"ide.inplace.errors.outline") && Boolean.parseBoolean(String.valueOf(eop))) {
                DarculaUIUtil.paintErrorBorder(g2, r.width, r.height, 0, true, c.hasFocus());
            } else {
                JComponent jc = (JComponent)c;
                if (c.hasFocus()) {
                    g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                } else if (jc.isEnabled() && jc.getClientProperty("JTextField.hover") == Boolean.TRUE) {
                    g2.setColor(UIManager.getColor("TextField.hoverBorderColor"));
                } else {
                    g2.setColor(UIManager.getColor("TextField.borderColor"));
                }
                if (!jc.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                Path2D.Double border = new Path2D.Double(0);
                border.append(r, false);
                Rectangle innerRect = new Rectangle(r);
                JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)1));
                border.append(innerRect, false);
                g2.fill(border);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

