/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class WinIntelliJTextFieldUI
extends DarculaTextFieldUI {
    public static final String HOVER_PROPERTY = "JTextField.hover";
    private MouseListener hoverListener;

    public WinIntelliJTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJTextFieldUI((JTextField)c);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.hoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.myTextField, HOVER_PROPERTY);
        this.myTextField.addMouseListener(this.hoverListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.hoverListener != null) {
            this.myTextField.removeMouseListener(this.hoverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        if (UIUtil.getParentOfType(JComboBox.class, (Component)c) != null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            WinIntelliJTextFieldUI.paintTextFieldBackground(c, g2);
            if (WinIntelliJTextFieldUI.isSearchField(c)) {
                this.paintSearchField(g2, c, this.getDrawingRect());
            }
        }
        finally {
            g2.dispose();
        }
    }

    static void paintTextFieldBackground(JComponent c, Graphics2D g2) {
        g2.setColor(c.isEnabled() ? c.getBackground() : UIManager.getColor("Button.background"));
        if (!c.isEnabled()) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
        }
        Rectangle r = new Rectangle(c.getSize());
        if (UIUtil.getParentOfType(JSpinner.class, (Component)c) == null) {
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2));
            WinIntelliJTextFieldUI.adjustInWrapperRect(r, c);
        }
        g2.fill(r);
    }

    static void adjustInWrapperRect(Rectangle r, Component c) {
        int delta;
        if (UIUtil.getParentOfType(Wrapper.class, (Component)c) != null && WinIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c) && (delta = c.getHeight() - c.getPreferredSize().height) > 0) {
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)((delta -= delta % 2 == 0 ? 0 : 1) / 2), (int)0));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        size.height = Math.max(JBUI.scale((int)24), size.height);
        return size;
    }

    @Override
    protected void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        Icon searchIcon;
        Icon icon = searchIcon = WinIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c) ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
        if (searchIcon == null) {
            searchIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/search.png", DarculaTextFieldUI.class, (boolean)true);
        }
        if (searchIcon != null) {
            int yOffset = WinIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c) ? JBUI.scale((int)1) : 0;
            searchIcon.paintIcon(c, g, JBUI.scale((int)5), (c.getHeight() - searchIcon.getIconHeight()) / 2 + yOffset);
        }
        if (this.hasText()) {
            Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
            if (clearIcon == null) {
                clearIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
            }
            if (clearIcon != null) {
                clearIcon.paintIcon(c, g, c.getWidth() - clearIcon.getIconWidth() - JBUI.scale((int)5), (c.getHeight() - clearIcon.getIconHeight()) / 2);
            }
        }
    }
}

