/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchableOptionPreloader
extends PreloadingActivity {
    @Override
    public void preload(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/ui/search/SearchableOptionPreloader", "preload"));
        }
        final SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        SearchableOptionProcessor processor2 = new SearchableOptionProcessor(){

            public void addOptions(@NotNull String text2, @Nullable String path, @Nullable String hit, @NotNull String configurableId, @Nullable String configurableDisplayName, boolean applyStemming) {
                if (text2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/ui/search/SearchableOptionPreloader$1", "addOptions"));
                }
                if (configurableId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableId", "com/intellij/ide/ui/search/SearchableOptionPreloader$1", "addOptions"));
                }
                Set words = applyStemming ? registrar.getProcessedWords(text2) : registrar.getProcessedWordsWithoutStemming(text2);
                for (String word : words) {
                    registrar.addOption(word, path, hit, configurableId, configurableDisplayName);
                }
            }
        };
        for (SearchableOptionContributor contributor : (SearchableOptionContributor[])SearchableOptionContributor.EP_NAME.getExtensions()) {
            indicator.checkCanceled();
            contributor.processOptions(processor2);
        }
    }
}

