/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import javax.swing.Icon;

public class MethodCellRenderer
extends PsiElementListCellRenderer<PsiMethod> {
    private final boolean myShowMethodNames;
    private final PsiClassListCellRenderer myClassListCellRenderer = new PsiClassListCellRenderer();
    @PsiFormatUtil.FormatMethodOptions
    private final int myOptions;

    public MethodCellRenderer(boolean showMethodNames) {
        this(showMethodNames, 257);
    }

    public MethodCellRenderer(boolean showMethodNames, @PsiFormatUtil.FormatMethodOptions int options) {
        this.myShowMethodNames = showMethodNames;
        this.myOptions = options;
    }

    @Override
    public String getElementText(PsiMethod element) {
        String text2;
        PsiNamedElement container = MethodCellRenderer.fetchContainer(element);
        String string = text2 = container instanceof PsiClass ? this.myClassListCellRenderer.getElementText((PsiClass)container) : container.getName();
        if (this.myShowMethodNames) {
            text2 = text2 + "." + PsiFormatUtil.formatMethod((PsiMethod)element, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)this.myOptions, (int)2);
        }
        return text2;
    }

    @Override
    protected Icon getIcon(PsiElement element) {
        return super.getIcon((PsiElement)(this.myShowMethodNames ? element : MethodCellRenderer.fetchContainer((PsiMethod)element)));
    }

    private static PsiNamedElement fetchContainer(PsiMethod element) {
        PsiClass aClass = element.getContainingClass();
        return aClass == null ? element.getContainingFile() : aClass;
    }

    @Override
    public String getContainerText(PsiMethod element, String name2) {
        return PsiClassListCellRenderer.getContainerTextStatic((PsiElement)element);
    }

    @Override
    public int getIconFlags() {
        return this.myClassListCellRenderer.getIconFlags();
    }
}

