/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private final Map<String, String> myMap = new LinkedHashMap<String, String>();
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    @NotNull
    public String getComponentName() {
        if ("PropertiesComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/PropertiesComponentImpl", "getComponentName"));
        }
        return "PropertiesComponent";
    }

    PropertiesComponentImpl() {
    }

    @Deprecated
    public static PropertiesComponentImpl create() {
        return new PropertiesComponentImpl();
    }

    public Element getState() {
        Element parentNode = new Element("state");
        for (String key2 : this.myMap.keySet()) {
            String value2 = this.myMap.get(key2);
            if (value2 == null) continue;
            Element element = new Element(ELEMENT_PROPERTY);
            element.setAttribute(ATTRIBUTE_NAME, key2);
            element.setAttribute(ATTRIBUTE_VALUE, value2);
            parentNode.addContent(element);
        }
        return parentNode;
    }

    public void loadState(Element parentNode) {
        this.myMap.clear();
        for (Element e : parentNode.getChildren(ELEMENT_PROPERTY)) {
            String name2 = e.getAttributeValue(ATTRIBUTE_NAME);
            if (name2 == null) continue;
            this.myMap.put(name2, e.getAttributeValue(ATTRIBUTE_VALUE));
        }
    }

    public String getValue(String name2) {
        return this.myMap.get(name2);
    }

    public void setValue(@NotNull String name2, @Nullable String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/util/PropertiesComponentImpl", "setValue"));
        }
        if (value2 == null) {
            this.myMap.remove(name2);
        } else {
            this.myMap.put(name2, value2);
        }
    }

    public void setValue(@NotNull String name2, @Nullable String value2, @Nullable String defaultValue) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/util/PropertiesComponentImpl", "setValue"));
        }
        if (value2 == null || value2.equals(defaultValue)) {
            this.myMap.remove(name2);
        } else {
            this.myMap.put(name2, value2);
        }
    }

    public void setValue(@NotNull String name2, float value2, float defaultValue) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/util/PropertiesComponentImpl", "setValue"));
        }
        if (value2 == defaultValue) {
            this.myMap.remove(name2);
        } else {
            this.myMap.put(name2, String.valueOf(value2));
        }
    }

    public void setValue(@NotNull String name2, int value2, int defaultValue) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/util/PropertiesComponentImpl", "setValue"));
        }
        if (value2 == defaultValue) {
            this.myMap.remove(name2);
        } else {
            this.myMap.put(name2, String.valueOf(value2));
        }
    }

    public void setValue(@NotNull String name2, boolean value2, boolean defaultValue) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/util/PropertiesComponentImpl", "setValue"));
        }
        if (value2 == defaultValue) {
            this.myMap.remove(name2);
        } else {
            this.setValue(name2, String.valueOf(value2));
        }
    }

    public void unsetValue(String name2) {
        this.myMap.remove(name2);
    }

    public boolean isValueSet(String name2) {
        return this.myMap.containsKey(name2);
    }

    @Nullable
    public String[] getValues(@NonNls String name2) {
        String value2 = this.getValue(name2);
        return value2 != null ? value2.split("\n") : null;
    }

    public void setValues(@NonNls String name2, String[] values) {
        if (values == null) {
            this.setValue(name2, null);
        } else {
            this.setValue(name2, StringUtil.join((String[])values, (String)"\n"));
        }
    }
}

