/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.intellij.Patches;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.gotoByName.SelectIndex;
import com.intellij.ide.util.gotoByName.SelectMostRelevant;
import com.intellij.ide.util.gotoByName.SelectionPolicy;
import com.intellij.ide.util.gotoByName.SelectionPolicyKt;
import com.intellij.ide.util.gotoByName.SelectionSnapshot;
import com.intellij.ide.util.gotoByName.SmartPointerListModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameBase {
    public static final String TEMPORARILY_FOCUSABLE_COMPONENT_KEY = "ChooseByNameBase.TemporarilyFocusableComponent";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameBase");
    protected final Project myProject;
    protected final ChooseByNameModel myModel;
    protected ChooseByNameItemProvider myProvider;
    protected final String myInitialText;
    private boolean mySearchInAnyPlace;
    protected Component myPreviouslyFocusedComponent;
    private boolean myInitialized;
    protected final JPanelProvider myTextFieldPanel;
    protected final MyTextField myTextField;
    private final CardLayout myCard;
    private final JPanel myCardContainer;
    protected final JCheckBox myCheckBox;
    private JComponent myToolArea;
    protected JScrollPane myListScrollPane;
    private final SmartPointerListModel<Object> myListModel;
    protected final JList<Object> myList;
    private final List<Pair<String, Integer>> myHistory;
    private final List<Pair<String, Integer>> myFuture;
    protected ChooseByNamePopupComponent.Callback myActionListener;
    protected final Alarm myAlarm;
    private final ListUpdater myListUpdater;
    private boolean myDisposedFlag;
    private final String[][] myNames;
    private volatile CalcElementsThread myCalcElementsThread;
    private static int VISIBLE_LIST_SIZE_LIMIT = 10;
    private int myListSizeIncreasing;
    private int myMaximumListSizeLimit;
    @NonNls
    private static final String NOT_FOUND_IN_PROJECT_CARD = "syslib";
    @NonNls
    private static final String NOT_FOUND_CARD = "nfound";
    @NonNls
    private static final String CHECK_BOX_CARD = "chkbox";
    @NonNls
    private static final String SEARCHING_CARD = "searching";
    private final int myRebuildDelay;
    private final Alarm myHideAlarm;
    private boolean myShowListAfterCompletionKeyStroke;
    protected JBPopup myTextPopup;
    protected JBPopup myDropdownPopup;
    private boolean myClosedByShiftEnter;
    protected final int myInitialIndex;
    private String myFindUsagesTitle;
    private ShortcutSet myCheckBoxShortcut;
    protected boolean myInitIsDone;
    static final boolean ourLoadNamesEachTime = FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    private boolean myAlwaysHasMore;
    private Point myFocusPoint;
    private SelectionSnapshot myCurrentChosenInfo;
    public static final String EXTRA_ELEM = "...";
    private static final String ACTION_NAME = "Show All in View";

    public boolean checkDisposed() {
        return this.myDisposedFlag;
    }

    public void setDisposed(boolean disposedFlag) {
        this.myDisposedFlag = disposedFlag;
        if (disposedFlag) {
            this.setNamesSync(true, null);
            this.setNamesSync(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamesSync(boolean checkboxState, @Nullable String[] value2) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            this.myNames[checkboxState ? 1 : 0] = value2;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected ChooseByNameBase(Project project2, @NotNull ChooseByNameModel model, String initialText, PsiElement context) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        this(project2, model, new DefaultChooseByNameItemProvider(context), initialText, 0);
    }

    protected ChooseByNameBase(Project project2, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, String initialText) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        this(project2, model, provider, initialText, 0);
    }

    protected ChooseByNameBase(Project project2, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, String initialText, int initialIndex) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "<init>"));
        }
        this.mySearchInAnyPlace = false;
        this.myTextFieldPanel = new JPanelProvider();
        this.myTextField = new MyTextField();
        this.myCard = new CardLayout();
        this.myCardContainer = new JPanel(this.myCard);
        this.myCheckBox = new JCheckBox();
        this.myListModel = new SmartPointerListModel();
        this.myList = new JBList(this.myListModel);
        this.myHistory = ContainerUtil.newArrayList();
        this.myFuture = ContainerUtil.newArrayList();
        this.myAlarm = new Alarm();
        this.myListUpdater = new ListUpdater();
        this.myDisposedFlag = false;
        this.myNames = new String[2][];
        this.myListSizeIncreasing = 30;
        this.myMaximumListSizeLimit = 30;
        this.myHideAlarm = new Alarm();
        this.myShowListAfterCompletionKeyStroke = false;
        this.myClosedByShiftEnter = false;
        this.myAlwaysHasMore = false;
        this.myProject = project2;
        this.myModel = model;
        this.myInitialText = initialText;
        this.myProvider = provider;
        this.myInitialIndex = initialIndex;
        this.mySearchInAnyPlace = Registry.is((String)"ide.goto.middle.matching") && model.useMiddleMatching();
        this.myRebuildDelay = Registry.intValue((String)"ide.goto.rebuild.delay");
        this.myTextField.setText(this.myInitialText);
        this.myInitIsDone = true;
    }

    public void setShowListAfterCompletionKeyStroke(boolean showListAfterCompletionKeyStroke) {
        this.myShowListAfterCompletionKeyStroke = showListAfterCompletionKeyStroke;
    }

    public boolean isSearchInAnyPlace() {
        return this.mySearchInAnyPlace;
    }

    public void setSearchInAnyPlace(boolean searchInAnyPlace) {
        this.mySearchInAnyPlace = searchInAnyPlace;
    }

    public boolean isClosedByShiftEnter() {
        return this.myClosedByShiftEnter;
    }

    public boolean isOpenInCurrentWindowRequested() {
        return this.isClosedByShiftEnter();
    }

    public void setToolArea(JComponent toolArea) {
        if (this.myToolArea != null) {
            throw new IllegalStateException("Tool area is modifiable only before invoke()");
        }
        this.myToolArea = toolArea;
    }

    public void setFindUsagesTitle(@Nullable String findUsagesTitle) {
        this.myFindUsagesTitle = findUsagesTitle;
    }

    public void invoke(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        this.initUI(callback, modalityState, allowMultipleSelection);
    }

    @NotNull
    public ChooseByNameModel getModel() {
        ChooseByNameModel chooseByNameModel = this.myModel;
        if (chooseByNameModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getModel"));
        }
        return chooseByNameModel;
    }

    protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        this.myPreviouslyFocusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myActionListener = callback;
        this.myTextFieldPanel.setLayout(new BoxLayout(this.myTextFieldPanel, 1));
        JPanel hBox = new JPanel();
        hBox.setLayout(new BoxLayout(hBox, 0));
        JPanel caption2Tools = new JPanel(new BorderLayout());
        if (this.myModel.getPromptText() != null) {
            JLabel label = new JLabel(this.myModel.getPromptText());
            label.setFont(UIUtil.getLabelFont().deriveFont(1));
            caption2Tools.add((Component)label, "West");
        }
        caption2Tools.add((Component)hBox, "East");
        this.myCardContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        String checkBoxName = this.myModel.getCheckBoxName();
        this.myCheckBox.setText(checkBoxName != null ? checkBoxName + (this.myCheckBoxShortcut != null && this.myCheckBoxShortcut.getShortcuts().length > 0 ? " (" + KeymapUtil.getShortcutsText((Shortcut[])this.myCheckBoxShortcut.getShortcuts()) + ")" : "") : "");
        this.myCheckBox.setAlignmentX(4.0f);
        if (!SystemInfo.isMac) {
            this.myCheckBox.setBorder(null);
        }
        this.myCheckBox.setSelected(this.myModel.loadInitialCheckBoxState());
        if (checkBoxName == null) {
            this.myCheckBox.setVisible(false);
        }
        this.addCard(this.myCheckBox, CHECK_BOX_CARD);
        this.addCard(new HintLabel(this.myModel.getNotInMessage()), NOT_FOUND_IN_PROJECT_CARD);
        this.addCard(new HintLabel(IdeBundle.message((String)"label.choosebyname.no.matches.found", (Object[])new Object[0])), NOT_FOUND_CARD);
        JPanel searching = new JPanel(new BorderLayout(5, 0));
        searching.add((Component)new AsyncProcessIcon(SEARCHING_CARD), "West");
        searching.add((Component)new HintLabel(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0])), "Center");
        this.addCard(searching, SEARCHING_CARD);
        this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
        if (this.isCheckboxVisible()) {
            hBox.add(this.myCardContainer);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShowFindUsagesAction(){

            @Override
            public PsiElement[] getElements() {
                List objects = ChooseByNameBase.this.myListModel.getItems();
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>(objects.size());
                for (Object object : objects) {
                    if (object instanceof PsiElement) {
                        elements.add((PsiElement)object);
                        continue;
                    }
                    if (!(object instanceof DataProvider)) continue;
                    ContainerUtil.addIfNotNull(elements, (Object)CommonDataKeys.PSI_ELEMENT.getData((DataProvider)object));
                }
                return PsiUtilCore.toPsiElementArray(elements);
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ChooseByNameBase", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(0);
        actionToolbar.updateActionsImmediately();
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setBorder(null);
        if (this.myToolArea == null) {
            this.myToolArea = new JLabel((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)24)));
        }
        hBox.add(this.myToolArea);
        hBox.add(toolbarComponent);
        this.myTextFieldPanel.add(caption2Tools);
        new MyCopyReferenceAction().registerCustomShortcutSet(ActionManager.getInstance().getAction("$Copy").getShortcutSet(), this.myTextField);
        this.myTextFieldPanel.add(this.myTextField);
        Font editorFont = EditorUtil.getEditorFont();
        this.myTextField.setFont(editorFont);
        if (checkBoxName != null && this.myCheckBoxShortcut != null) {
            new DumbAwareAction("change goto check box", null, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$2", "actionPerformed"));
                    }
                    ChooseByNameBase.this.myCheckBox.setSelected(!ChooseByNameBase.this.myCheckBox.isSelected());
                }
            }.registerCustomShortcutSet(this.myCheckBoxShortcut, (JComponent)this.myTextField);
        }
        if (this.isCloseByFocusLost()) {
            this.myTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(@NotNull FocusEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$3", "focusLost"));
                    }
                    if (Registry.is((String)"focus.follows.mouse.workarounds")) {
                        PointerInfo pointerInfo;
                        if (ChooseByNameBase.this.myFocusPoint != null && (pointerInfo = MouseInfo.getPointerInfo()) != null && ChooseByNameBase.this.myFocusPoint.equals(pointerInfo.getLocation())) {
                            IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                            ChooseByNameBase.this.myFocusPoint = null;
                            return;
                        }
                        ChooseByNameBase.this.myFocusPoint = null;
                    }
                    ChooseByNameBase.this.cancelListUpdater();
                    ChooseByNameBase.this.myHideAlarm.addRequest(() -> {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$3", "lambda$focusLost$0"));
                        }
                        JBPopup popup = JBPopupFactory.getInstance().getChildFocusedPopup(e.getComponent());
                        if (popup != null) {
                            popup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

                                public void onClosed(@NotNull LightweightWindowEvent event) {
                                    if (event == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/gotoByName/ChooseByNameBase$3$1", "onClosed"));
                                    }
                                    if (event.isOk()) {
                                        ChooseByNameBase.this.hideHint();
                                    }
                                }
                            });
                        } else {
                            Component oppositeComponent = e.getOppositeComponent();
                            if (oppositeComponent == ChooseByNameBase.this.myCheckBox) {
                                IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                return;
                            }
                            if (oppositeComponent != null && !(oppositeComponent instanceof JFrame) && ChooseByNameBase.this.myList.isShowing() && (oppositeComponent == ChooseByNameBase.this.myList || SwingUtilities.isDescendingFrom(ChooseByNameBase.this.myList, oppositeComponent))) {
                                IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                return;
                            }
                            if (ChooseByNameBase.this.isDescendingFromTemporarilyFocusableToolWindow(oppositeComponent)) {
                                return;
                            }
                            ChooseByNameBase.this.hideHint();
                        }
                    }, 5);
                }
            });
        }
        this.myCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$4", "itemStateChanged"));
                }
                ChooseByNameBase.this.rebuildList(false);
            }
        });
        this.myCheckBox.setFocusable(false);
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SelectMostRelevant toSelect2 = ChooseByNameBase.this.myCurrentChosenInfo != null && ChooseByNameBase.this.myCurrentChosenInfo.hasSamePattern(ChooseByNameBase.this) ? ChooseByNameBase.this.myCurrentChosenInfo : SelectMostRelevant.INSTANCE;
                ChooseByNameBase.this.rebuildList(toSelect2, ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
            }
        });
        final Set<KeyStroke> upShortcuts = ChooseByNameBase.getShortcuts("EditorUp");
        final Set<KeyStroke> downShortcuts = ChooseByNameBase.getShortcuts("EditorDown");
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$6", "keyPressed"));
                }
                if (e.getKeyCode() == 10 && (e.getModifiers() & 1) != 0) {
                    ChooseByNameBase.this.myClosedByShiftEnter = true;
                    ChooseByNameBase.this.close(true);
                }
                if (!ChooseByNameBase.this.myListScrollPane.isVisible()) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = upShortcuts.contains(stroke) ? 38 : (downShortcuts.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ScrollingUtil.moveDown(ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ScrollingUtil.moveUp(ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ScrollingUtil.movePageUp(ChooseByNameBase.this.myList);
                        break;
                    }
                    case 34: {
                        ScrollingUtil.movePageDown(ChooseByNameBase.this.myList);
                        break;
                    }
                    case 9: {
                        ChooseByNameBase.this.close(true);
                        break;
                    }
                    case 10: {
                        if (ChooseByNameBase.this.myList.getSelectedValue() != ChooseByNameBase.EXTRA_ELEM) break;
                        ChooseByNameBase.this.myMaximumListSizeLimit = ChooseByNameBase.this.myMaximumListSizeLimit + ChooseByNameBase.this.myListSizeIncreasing;
                        ChooseByNameBase.this.rebuildList(new SelectIndex(ChooseByNameBase.this.myList.getSelectedIndex()), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        e.consume();
                    }
                }
            }
        });
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent actionEvent) {
                if (actionEvent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionEvent", "com/intellij/ide/util/gotoByName/ChooseByNameBase$7", "actionPerformed"));
                }
                ChooseByNameBase.this.doClose(true);
            }
        });
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(allowMultipleSelection ? 2 : 0);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$8", "onClick"));
                }
                if (!ChooseByNameBase.this.myTextField.hasFocus()) {
                    IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                }
                if (clickCount == 2) {
                    int selectedIndex = ChooseByNameBase.this.myList.getSelectedIndex();
                    Rectangle selectedCellBounds = ChooseByNameBase.this.myList.getCellBounds(selectedIndex, selectedIndex);
                    if (selectedCellBounds != null && selectedCellBounds.contains(e.getPoint())) {
                        if (ChooseByNameBase.this.myList.getSelectedValue() == ChooseByNameBase.EXTRA_ELEM) {
                            ChooseByNameBase.this.myMaximumListSizeLimit = ChooseByNameBase.this.myMaximumListSizeLimit + ChooseByNameBase.this.myListSizeIncreasing;
                            ChooseByNameBase.this.rebuildList(new SelectIndex(selectedIndex), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        } else {
                            ChooseByNameBase.this.doClose(true);
                        }
                    }
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        this.myList.setCellRenderer(this.myModel.getListCellRenderer());
        this.myList.setFont(editorFont);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$9", "valueChanged"));
                }
                ChooseByNameBase.this.chosenElementMightChange();
                ChooseByNameBase.this.updateDocumentation();
                List<Object> chosenElements = ChooseByNameBase.this.getChosenElements();
                if (!chosenElements.isEmpty()) {
                    ChooseByNameBase.this.myCurrentChosenInfo = new SelectionSnapshot(ChooseByNameBase.this.getTrimmedText(), new HashSet<Object>(chosenElements));
                }
            }
        });
        this.myListScrollPane = ScrollPaneFactory.createScrollPane(this.myList);
        this.myListScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.myTextFieldPanel.setBorder(JBUI.Borders.empty((int)5));
        this.showTextFieldPanel();
        this.myInitialized = true;
        if (modalityState != null) {
            this.rebuildList(SelectionPolicyKt.fromIndex(this.myInitialIndex), 0, modalityState, null);
        }
    }

    private boolean isDescendingFromTemporarilyFocusableToolWindow(@Nullable Component component) {
        if (component == null || this.myProject == null || this.myProject.isDisposed()) {
            return false;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowManager.getActiveToolWindowId());
        JComponent toolWindowComponent = toolWindow != null ? toolWindow.getComponent() : null;
        return toolWindowComponent != null && toolWindowComponent.getClientProperty(TEMPORARILY_FOCUSABLE_COMPONENT_KEY) != null && SwingUtilities.isDescendingFrom(component, toolWindowComponent);
    }

    private void addCard(JComponent comp, String cardId) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)comp, "East");
        this.myCardContainer.add((Component)wrapper, cardId);
    }

    public void setCheckBoxShortcut(ShortcutSet shortcutSet) {
        this.myCheckBoxShortcut = shortcutSet;
    }

    @NotNull
    private static Set<KeyStroke> getShortcuts(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getShortcuts"));
        }
        HashSet<KeyStroke> result2 = new HashSet<KeyStroke>();
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            result2.add(keyboardShortcut.getFirstKeyStroke());
        }
        HashSet<KeyStroke> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getShortcuts"));
        }
        return hashSet;
    }

    private void hideHint() {
        if (!this.myTextFieldPanel.focusRequested()) {
            this.doClose(false);
            this.myTextFieldPanel.hideHint();
        }
    }

    public void rebuildList(boolean initial) {
        this.rebuildList(initial ? SelectionPolicyKt.fromIndex(this.myInitialIndex) : SelectMostRelevant.INSTANCE, this.myRebuildDelay, ModalityState.current(), null);
    }

    private void updateDocumentation() {
        JBPopup hint = this.myTextFieldPanel.getHint();
        Object element = this.getChosenElement();
        if (hint != null) {
            Object o;
            if (element instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)element);
            } else if (element instanceof DataProvider && (o = ((DataProvider)element).getData(CommonDataKeys.PSI_ELEMENT.getName())) instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)o);
            }
        }
    }

    public String transformPattern(String pattern) {
        return pattern;
    }

    protected void doClose(boolean ok) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.closeForbidden(ok) || this.getChosenElements().isEmpty()) {
            return;
        }
        this.cancelListUpdater();
        this.close(ok);
        this.myListModel.removeAll();
    }

    protected boolean closeForbidden(boolean ok) {
        return false;
    }

    protected void cancelListUpdater() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.checkDisposed()) {
            return;
        }
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
            this.myCalcElementsThread = null;
        }
        this.myListUpdater.cancelAll();
    }

    @NotNull
    public String getTrimmedText() {
        String string = StringUtil.trimLeading((String)StringUtil.notNullize((String)this.myTextField.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getTrimmedText"));
        }
        return string;
    }

    @NotNull
    private synchronized String[] ensureNamesLoaded(boolean checkboxState) {
        String[] cached = this.getNamesSync(checkboxState);
        if (cached != null) {
            if (cached == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "ensureNamesLoaded"));
            }
            return cached;
        }
        if (checkboxState && this.myModel instanceof ContributorsBasedGotoByModel && ((ContributorsBasedGotoByModel)this.myModel).sameNamesForProjectAndLibraries() && this.getNamesSync(false) != null) {
            String[] allNames = this.getNamesSync(false);
            this.setNamesSync(true, allNames);
            if (allNames == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "ensureNamesLoaded"));
            }
            return allNames;
        }
        String[] result2 = this.myModel.getNames(checkboxState);
        assert (result2 != null) : "Model " + this.myModel + "(" + this.myModel.getClass() + ") returned null names";
        this.setNamesSync(checkboxState, result2);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "ensureNamesLoaded"));
        }
        return result2;
    }

    @NotNull
    public String[] getNames(boolean checkboxState) {
        if (ourLoadNamesEachTime) {
            this.setNamesSync(checkboxState, null);
            String[] stringArray = this.ensureNamesLoaded(checkboxState);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getNames"));
            }
            return stringArray;
        }
        String[] stringArray = this.getNamesSync(checkboxState);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "getNames"));
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNamesSync(boolean checkboxState) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.myNames[checkboxState ? 1 : 0];
        }
    }

    @NotNull
    protected Set<Object> filter(@NotNull Set<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "filter"));
        }
        Set<Object> set2 = elements;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "filter"));
        }
        return set2;
    }

    protected abstract boolean isCheckboxVisible();

    protected abstract boolean isShowListForEmptyPattern();

    protected abstract boolean isCloseByFocusLost();

    protected void showTextFieldPanel() {
        JLayeredPane layeredPane = this.getLayeredPane();
        Dimension preferredTextFieldPanelSize = this.myTextFieldPanel.getPreferredSize();
        int x = (layeredPane.getWidth() - preferredTextFieldPanelSize.width) / 2;
        int paneHeight = layeredPane.getHeight();
        int y = paneHeight / 3 - preferredTextFieldPanelSize.height / 2;
        VISIBLE_LIST_SIZE_LIMIT = Math.max(10, (paneHeight - (y + preferredTextFieldPanelSize.height)) / (preferredTextFieldPanelSize.height / 2) - 1);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myTextFieldPanel, (JComponent)this.myTextField);
        builder.setLocateWithinScreenBounds(false);
        builder.setKeyEventHandler(event -> {
            if (this.myTextPopup == null || !AbstractPopup.isCloseRequest(event) || !this.myTextPopup.isCancelKeyEnabled()) {
                return false;
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
            if (this.isDescendingFromTemporarilyFocusableToolWindow(focusManager.getFocusOwner())) {
                focusManager.requestFocus((Component)this.myTextField, true);
                return false;
            }
            this.myTextPopup.cancel((InputEvent)event);
            return true;
        }).setCancelCallback(() -> {
            this.myTextPopup = null;
            this.close(false);
            return Boolean.TRUE;
        }).setFocusable(true).setRequestFocus(true).setModalContext(false).setCancelOnClickOutside(false);
        Point point = new Point(x, y);
        SwingUtilities.convertPointToScreen(point, layeredPane);
        Rectangle bounds = new Rectangle(point, new Dimension(preferredTextFieldPanelSize.width + 20, preferredTextFieldPanelSize.height));
        this.myTextPopup = builder.createPopup();
        this.myTextPopup.setSize(bounds.getSize());
        this.myTextPopup.setLocation(bounds.getLocation());
        MnemonicHelper.init((Component)this.myTextFieldPanel);
        if (this.myProject != null && !this.myProject.isDefault()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this.myTextPopup);
        }
        Disposer.register((Disposable)this.myTextPopup, (Disposable)new Disposable(){

            public void dispose() {
                ChooseByNameBase.this.cancelListUpdater();
            }
        });
        this.myTextPopup.show((Component)layeredPane);
    }

    private JLayeredPane getLayeredPane() {
        JLayeredPane layeredPane;
        Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof JFrame) {
            layeredPane = ((JFrame)parent).getLayeredPane();
        } else if (parent instanceof JDialog) {
            layeredPane = ((JDialog)parent).getLayeredPane();
        } else {
            throw new IllegalStateException("cannot find parent window: project=" + this.myProject + (this.myProject != null ? "; open=" + this.myProject.isOpen() : "") + "; window=" + window);
        }
        return layeredPane;
    }

    protected void rebuildList(SelectionPolicy pos, int delay, @NotNull ModalityState modalityState, @Nullable Runnable postRunnable) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "rebuildList"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myInitialized) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (delay > 0) {
            this.myAlarm.addRequest(() -> {
                if (modalityState == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "lambda$rebuildList$2"));
                }
                this.rebuildList(pos, 0, modalityState, postRunnable);
            }, delay, ModalityState.stateForComponent((Component)this.myTextField));
            return;
        }
        this.myListUpdater.cancelAll();
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
        }
        String text2 = this.getTrimmedText();
        if (!this.canShowListForEmptyPattern() && text2.isEmpty()) {
            this.myListModel.removeAll();
            this.hideList();
            this.myTextFieldPanel.hideHint();
            this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
            return;
        }
        ListCellRenderer cellRenderer = this.myList.getCellRenderer();
        if (cellRenderer instanceof ExpandedItemListCellRendererWrapper) {
            cellRenderer = ((ExpandedItemListCellRendererWrapper)cellRenderer).getWrappee();
        }
        String pattern = ChooseByNameBase.patternToLowerCase(this.transformPattern(text2));
        Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.isSearchInAnyPlace() ? "*" + pattern : pattern);
        if (cellRenderer instanceof MatcherHolder) {
            ((MatcherHolder)((Object)cellRenderer)).setPatternMatcher(matcher);
        }
        MatcherHolder.associateMatcher(this.myList, matcher);
        this.scheduleCalcElements(text2, this.myCheckBox.isSelected(), modalityState, elements -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.backgroundCalculationFinished((Collection<?>)elements, pos);
            if (postRunnable != null) {
                postRunnable.run();
            }
        });
    }

    private void backgroundCalculationFinished(Collection<?> result2, SelectionPolicy toSelect2) {
        this.myCalcElementsThread = null;
        this.setElementsToList(toSelect2, result2);
        this.myList.repaint();
        this.chosenElementMightChange();
        if (result2.isEmpty()) {
            this.myTextFieldPanel.hideHint();
        }
    }

    public void scheduleCalcElements(String text2, boolean checkboxState, ModalityState modalityState, Consumer<Set<?>> callback) {
        new CalcElementsThread(text2, checkboxState, callback, modalityState).scheduleThread();
    }

    private boolean isShowListAfterCompletionKeyStroke() {
        return this.myShowListAfterCompletionKeyStroke;
    }

    private void setElementsToList(SelectionPolicy pos, @NotNull Collection<?> elements) {
        PointerInfo pointerInfo;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "setElementsToList"));
        }
        this.myListUpdater.cancelAll();
        if (this.checkDisposed()) {
            return;
        }
        if (this.isCloseByFocusLost() && Registry.is((String)"focus.follows.mouse.workarounds") && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
            this.myFocusPoint = pointerInfo.getLocation();
        }
        if (elements.isEmpty()) {
            this.myListModel.removeAll();
            this.myTextField.setForeground((Color)JBColor.red);
            this.myListUpdater.cancelAll();
            this.hideList();
            return;
        }
        Object[] oldElements = this.myListModel.getItems().toArray();
        Object[] newElements = elements.toArray();
        if (ArrayUtil.contains(null, (Object[])newElements)) {
            LOG.error("Null after filtering elements by " + this);
        }
        List<ModelDiff.Cmd> commands = ModelDiff.createDiffCmds(this.myListModel, oldElements, newElements);
        this.myTextField.setForeground(UIUtil.getTextFieldForeground());
        if (commands == null || commands.isEmpty()) {
            this.applySelection(pos);
            this.myList.setVisibleRowCount(Math.min(VISIBLE_LIST_SIZE_LIMIT, this.myList.getModel().getSize()));
            this.showList();
            this.myTextFieldPanel.repositionHint();
        } else {
            this.showList();
            this.myListUpdater.appendToModel(commands, pos);
        }
    }

    @VisibleForTesting
    public int calcSelectedIndex(Object[] modelElements, String trimmedText) {
        int bestPosition;
        if (this.myModel instanceof Comparator) {
            return 0;
        }
        Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.transformPattern(trimmedText));
        String statContext = this.statisticsContext();
        Comparator<Object> itemComparator = Comparator.comparing(e -> trimmedText.equalsIgnoreCase(this.myModel.getElementName(e))).thenComparing(e -> this.matchingDegree(matcher, e)).thenComparing(e -> this.getUseCount(statContext, e)).reversed();
        for (bestPosition = 0; bestPosition < modelElements.length - 1 && ChooseByNameBase.isSpecialElement(modelElements[bestPosition]); ++bestPosition) {
        }
        for (int i2 = 1; i2 < modelElements.length; ++i2) {
            Object modelElement = modelElements[i2];
            if (ChooseByNameBase.isSpecialElement(modelElement) || itemComparator.compare(modelElement, modelElements[bestPosition]) >= 0) continue;
            bestPosition = i2;
        }
        return bestPosition;
    }

    private static boolean isSpecialElement(Object modelElement) {
        return EXTRA_ELEM.equals(modelElement);
    }

    private int getUseCount(String statContext, Object modelElement) {
        String text2 = this.myModel.getFullName(modelElement);
        return text2 == null ? Integer.MIN_VALUE : StatisticsManager.getInstance().getUseCount(new StatisticsInfo(statContext, text2));
    }

    private int matchingDegree(Matcher matcher, Object modelElement) {
        String name2 = this.myModel.getElementName(modelElement);
        return name2 != null && matcher instanceof MinusculeMatcher ? ((MinusculeMatcher)matcher).matchingDegree(name2) : Integer.MIN_VALUE;
    }

    @NotNull
    @NonNls
    protected String statisticsContext() {
        String string = "choose_by_name#" + this.myModel.getPromptText() + "#" + this.myCheckBox.isSelected() + "#" + this.getTrimmedText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "statisticsContext"));
        }
        return string;
    }

    private void applySelection(SelectionPolicy selection) {
        List<Integer> indices2 = selection.performSelection(this, this.myListModel);
        this.myList.setSelectedIndices(Ints.toArray(indices2));
        if (!indices2.isEmpty()) {
            ScrollingUtil.ensureIndexIsVisible(this.myList, (int)indices2.get(0), (int)0);
        }
    }

    @Deprecated
    public boolean hasPostponedAction() {
        return false;
    }

    protected abstract void showList();

    protected abstract void hideList();

    protected abstract void close(boolean var1);

    @Nullable
    public Object getChosenElement() {
        List<Object> elements = this.getChosenElements();
        return elements != null && elements.size() == 1 ? elements.get(0) : null;
    }

    protected List<Object> getChosenElements() {
        return ContainerUtil.filter(this.myList.getSelectedValuesList(), o -> !ChooseByNameBase.isSpecialElement(o));
    }

    protected void chosenElementMightChange() {
    }

    public ChooseByNameItemProvider getProvider() {
        return this.myProvider;
    }

    protected void handlePaste(String str) {
        if (!this.myInitIsDone) {
            return;
        }
        if (this.myModel instanceof GotoClassModel2 && ChooseByNameBase.isFileName(str)) {
            SwingUtilities.invokeLater(() -> {
                GotoFileAction gotoFile = new GotoFileAction();
                DataContext context = DataManager.getInstance().getDataContext((Component)this.myTextField);
                gotoFile.actionPerformed(AnActionEvent.createFromAnAction((AnAction)gotoFile, null, (String)"unknown", (DataContext)context));
            });
        }
    }

    private static boolean isFileName(String name2) {
        int index = name2.lastIndexOf(46);
        if (index > 0) {
            String ext = name2.substring(index + 1);
            if (ext.contains(":")) {
                ext = ext.substring(0, ext.indexOf(58));
            }
            if (FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(ext) != UnknownFileType.INSTANCE) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static String patternToLowerCase(String pattern) {
        String string = pattern.toLowerCase(Locale.US);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "patternToLowerCase"));
        }
        return string;
    }

    public boolean canShowListForEmptyPattern() {
        return this.isShowListForEmptyPattern() || this.isShowListAfterCompletionKeyStroke() && this.lastKeyStrokeIsCompletion();
    }

    protected boolean lastKeyStrokeIsCompletion() {
        return this.myTextField.isCompletionKeyStroke();
    }

    private static Matcher buildPatternMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase", "buildPatternMatcher"));
        }
        return NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    public int getMaximumListSizeLimit() {
        return this.myMaximumListSizeLimit;
    }

    public void setMaximumListSizeLimit(int maximumListSizeLimit) {
        this.myMaximumListSizeLimit = maximumListSizeLimit;
    }

    public void setListSizeIncreasing(int listSizeIncreasing) {
        this.myListSizeIncreasing = listSizeIncreasing;
    }

    public void setAlwaysHasMore(boolean enabled) {
        this.myAlwaysHasMore = enabled;
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    private class MyCopyReferenceAction
    extends DumbAwareAction {
        private MyCopyReferenceAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ChooseByNameBase.this.myTextField.getSelectedText() == null && ChooseByNameBase.this.getChosenElement() instanceof PsiElement);
        }

        public void actionPerformed(AnActionEvent e) {
            CopyReferenceAction.doCopy((PsiElement)ChooseByNameBase.this.getChosenElement(), ChooseByNameBase.this.myProject);
        }
    }

    private static class MyUsageInfo2UsageAdapter
    extends UsageInfo2UsageAdapter {
        private final PsiElement myElement;
        private final boolean mySeparateGroup;

        MyUsageInfo2UsageAdapter(@NotNull PsiElement element, final boolean separateGroup) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyUsageInfo2UsageAdapter", "<init>"));
            }
            super(new UsageInfo(element){

                public boolean isDynamicUsage() {
                    return separateGroup || super.isDynamicUsage();
                }
            });
            this.myElement = element;
            this.mySeparateGroup = separateGroup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyUsageInfo2UsageAdapter)) {
                return false;
            }
            MyUsageInfo2UsageAdapter adapter = (MyUsageInfo2UsageAdapter)((Object)o);
            if (this.mySeparateGroup != adapter.mySeparateGroup) {
                return false;
            }
            return this.myElement.equals(adapter.myElement);
        }

        public int hashCode() {
            int result2 = this.myElement.hashCode();
            result2 = 31 * result2 + (this.mySeparateGroup ? 1 : 0);
            return result2;
        }
    }

    private abstract class ShowFindUsagesAction
    extends DumbAwareAction {
        public ShowFindUsagesAction() {
            super(ChooseByNameBase.ACTION_NAME, ChooseByNameBase.ACTION_NAME, AllIcons.General.AutohideOff);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "actionPerformed"));
            }
            ChooseByNameBase.this.cancelListUpdater();
            final UsageViewPresentation presentation = new UsageViewPresentation();
            final String text2 = ChooseByNameBase.this.getTrimmedText();
            String prefixPattern = ChooseByNameBase.this.myFindUsagesTitle + " '" + text2 + "'";
            presentation.setCodeUsagesString(prefixPattern);
            presentation.setUsagesInGeneratedCodeString(prefixPattern + " in generated code");
            presentation.setTabName(prefixPattern);
            presentation.setTabText(prefixPattern);
            presentation.setTargetsNodeText("Unsorted " + StringUtil.toLowerCase((String)ChooseByNameBase.patternToLowerCase(prefixPattern)));
            PsiElement[] elements = this.getElements();
            final ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            this.fillUsages(Arrays.asList(elements), usages, targets, false);
            if (ChooseByNameBase.this.myListModel.contains(ChooseByNameBase.EXTRA_ELEM)) {
                final boolean everywhere = ChooseByNameBase.this.myCheckBox.isSelected();
                final LinkedHashSet collected = new LinkedHashSet();
                ChooseByNameBase.this.hideHint();
                ProgressManager.getInstance().run((Task)new Task.Modal(ChooseByNameBase.this.myProject, prefixPattern, true){
                    private CalcElementsThread myCalcUsagesThread;

                    public void run(final @NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1", "run"));
                        }
                        ChooseByNameBase.this.ensureNamesLoaded(everywhere);
                        indicator.setIndeterminate(true);
                        final TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(indicator);
                        this.myCalcUsagesThread = new CalcElementsThread(text2, everywhere, null, ModalityState.NON_MODAL){

                            @Override
                            protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
                                if (elementsArray == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsArray", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1$1", "isOverflow"));
                                }
                                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                                if (elementsArray.size() > 1000 - ChooseByNameBase.this.myMaximumListSizeLimit && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                    int usageCount = elementsArray.size() + ChooseByNameBase.this.myMaximumListSizeLimit;
                                    UsageViewManagerImpl.showTooManyUsagesWarning((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)indicator, (UsageViewPresentation)presentation, (int)usageCount, null);
                                }
                                return false;
                            }
                        };
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1", "lambda$run$0"));
                            }
                            this.myCalcUsagesThread.addElementsByPattern(text2, collected, indicator, everywhere);
                            indicator.setText("Prepare...");
                            ShowFindUsagesAction.this.fillUsages(collected, usages, targets, false);
                        });
                    }

                    public void onSuccess() {
                        ShowFindUsagesAction.this.showUsageView(targets, usages, presentation);
                    }

                    public void onCancel() {
                        this.myCalcUsagesThread.cancel();
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1", "onThrowable"));
                        }
                        super.onThrowable(error);
                        this.myCalcUsagesThread.cancel();
                    }
                });
            } else {
                ChooseByNameBase.this.hideHint();
                this.showUsageView(targets, usages, presentation);
            }
        }

        private void fillUsages(Collection<Object> matchElementsArray, Collection<Usage> usages, List<PsiElement> targets, boolean separateGroup) {
            for (Object o : matchElementsArray) {
                if (!(o instanceof PsiElement)) continue;
                PsiElement element = (PsiElement)o;
                if (element.getTextRange() != null) {
                    usages.add((Usage)new MyUsageInfo2UsageAdapter(element, separateGroup));
                    continue;
                }
                targets.add(element);
            }
        }

        private void showUsageView(@NotNull List<PsiElement> targets, @NotNull Collection<Usage> usages, @NotNull UsageViewPresentation presentation) {
            if (targets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "showUsageView"));
            }
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "showUsageView"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "showUsageView"));
            }
            UsageTarget[] usageTargets = targets.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets));
            UsageViewManager.getInstance((Project)ChooseByNameBase.this.myProject).showUsages(usageTargets, usages.toArray(new Usage[usages.size()]), presentation);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction", "update"));
            }
            if (ChooseByNameBase.this.myFindUsagesTitle == null || ChooseByNameBase.this.myProject == null) {
                e.getPresentation().setVisible(false);
                return;
            }
            PsiElement[] elements = this.getElements();
            e.getPresentation().setEnabled(elements != null && elements.length > 0);
        }

        public abstract PsiElement[] getElements();
    }

    private static class HintLabel
    extends JLabel {
        private HintLabel(String text2) {
            super(text2, 4);
            this.setForeground(Color.darkGray);
        }
    }

    private class CalcElementsThread
    extends ReadTask {
        private final String myPattern;
        private final boolean myCheckboxState;
        private final Consumer<Set<?>> myCallback;
        private final ModalityState myModalityState;
        private final ProgressIndicator myProgress;
        private final Alarm myShowCardAlarm;

        CalcElementsThread(String pattern, boolean checkboxState, @NotNull Consumer<Set<?>> callback, ModalityState modalityState) {
            if (modalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "<init>"));
            }
            this.myProgress = new ProgressIndicatorBase();
            this.myShowCardAlarm = new Alarm();
            this.myPattern = pattern;
            this.myCheckboxState = checkboxState;
            this.myCallback = callback;
            this.myModalityState = modalityState;
        }

        void scheduleThread() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ChooseByNameBase.this.myCalcElementsThread = this;
            this.showCard(ChooseByNameBase.SEARCHING_CARD, 200);
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, (ReadTask)this);
        }

        @Override
        public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "runBackgroundProcess"));
            }
            if (DumbService.isDumbAware((Object)ChooseByNameBase.this.myModel)) {
                return super.runBackgroundProcess(indicator);
            }
            return (ReadTask.Continuation)DumbService.getInstance((Project)ChooseByNameBase.this.myProject).runReadActionInSmartMode(() -> {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "lambda$runBackgroundProcess$0"));
                }
                return this.performInReadAction(indicator);
            });
        }

        @Override
        @Nullable
        public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "performInReadAction"));
            }
            if (ChooseByNameBase.this.myProject != null && ChooseByNameBase.this.myProject.isDisposed()) {
                return null;
            }
            LinkedHashSet<Object> elements = new LinkedHashSet<Object>();
            boolean scopeExpanded = this.populateElements(elements);
            String cardToShow = elements.isEmpty() ? ChooseByNameBase.NOT_FOUND_CARD : (scopeExpanded ? ChooseByNameBase.NOT_FOUND_IN_PROJECT_CARD : ChooseByNameBase.CHECK_BOX_CARD);
            Set<Object> filtered = ChooseByNameBase.this.filter(elements);
            return new ReadTask.Continuation(() -> {
                if (!ChooseByNameBase.this.checkDisposed() && !this.myProgress.isCanceled()) {
                    CalcElementsThread currentBgProcess = ChooseByNameBase.this.myCalcElementsThread;
                    LOG.assertTrue(currentBgProcess == this, (Object)currentBgProcess);
                    this.showCard(cardToShow, 0);
                    this.myCallback.consume((Object)filtered);
                }
            }, this.myModalityState);
        }

        private boolean populateElements(Set<Object> elements) {
            boolean scopeExpanded = false;
            try {
                scopeExpanded = this.fillWithScopeExpansion(elements, this.myPattern);
                String lowerCased = ChooseByNameBase.patternToLowerCase(this.myPattern);
                if (elements.isEmpty() && !lowerCased.equals(this.myPattern)) {
                    scopeExpanded = this.fillWithScopeExpansion(elements, lowerCased);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return scopeExpanded;
        }

        private boolean fillWithScopeExpansion(Set<Object> elements, String pattern) {
            if (!ourLoadNamesEachTime) {
                ChooseByNameBase.this.ensureNamesLoaded(this.myCheckboxState);
            }
            this.addElementsByPattern(pattern, elements, this.myProgress, this.myCheckboxState);
            if (elements.isEmpty() && !this.myCheckboxState) {
                if (!ourLoadNamesEachTime) {
                    ChooseByNameBase.this.ensureNamesLoaded(true);
                }
                this.addElementsByPattern(pattern, elements, this.myProgress, true);
                return true;
            }
            return false;
        }

        @Override
        public void onCanceled(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "onCanceled"));
            }
            LOG.assertTrue(ChooseByNameBase.this.myCalcElementsThread == this, (Object)ChooseByNameBase.this.myCalcElementsThread);
            if (!ChooseByNameBase.this.myProject.isDisposed()) {
                new CalcElementsThread(this.myPattern, this.myCheckboxState, this.myCallback, this.myModalityState).scheduleThread();
            }
        }

        private void addElementsByPattern(@NotNull String pattern, @NotNull Set<Object> elements, @NotNull ProgressIndicator indicator, boolean everywhere) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "addElementsByPattern"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "addElementsByPattern"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "addElementsByPattern"));
            }
            long start = System.currentTimeMillis();
            ChooseByNameBase.this.myProvider.filterElements(ChooseByNameBase.this, pattern, everywhere, indicator, (Processor<Object>)((Processor)o -> {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "lambda$addElementsByPattern$2"));
                }
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "lambda$addElementsByPattern$2"));
                }
                if (indicator.isCanceled()) {
                    return false;
                }
                if (o == null) {
                    LOG.error("Null returned from " + ChooseByNameBase.this.myProvider + " with " + ChooseByNameBase.this.myModel + " in " + ChooseByNameBase.this);
                    return true;
                }
                elements.add(o);
                if (this.isOverflow(elements)) {
                    elements.add(ChooseByNameBase.EXTRA_ELEM);
                    return false;
                }
                return true;
            }));
            if (ChooseByNameBase.this.myAlwaysHasMore) {
                elements.add(ChooseByNameBase.EXTRA_ELEM);
            }
            if (ContributorsBasedGotoByModel.LOG.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ContributorsBasedGotoByModel.LOG.debug("addElementsByPattern(" + pattern + "): " + (end - start) + "ms; " + elements.size() + " elements");
            }
        }

        private void showCard(String card, int delay) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myShowCardAlarm.cancelAllRequests();
            this.myShowCardAlarm.addRequest(() -> {
                if (!this.myProgress.isCanceled()) {
                    ChooseByNameBase.this.myCard.show(ChooseByNameBase.this.myCardContainer, card);
                }
            }, delay, this.myModalityState);
        }

        protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
            if (elementsArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsArray", "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread", "isOverflow"));
            }
            return elementsArray.size() >= ChooseByNameBase.this.myMaximumListSizeLimit;
        }

        private void cancel() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgress.cancel();
        }
    }

    protected final class MyTextField
    extends JTextField
    implements PopupOwner,
    TypeSafeDataProvider {
        private final KeyStroke myCompletionKeyStroke;
        private final KeyStroke forwardStroke;
        private final KeyStroke backStroke;
        private boolean completionKeyStrokeHappened;

        private MyTextField() {
            super(40);
            this.completionKeyStrokeHappened = false;
            if (!(UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel())) {
                if (!(this.getUI() instanceof DarculaTextFieldUI)) {
                    this.setUI(DarculaTextFieldUI.createUI(this));
                }
                this.setBorder(new DarculaTextBorder());
            }
            this.enableEvents(8L);
            this.myCompletionKeyStroke = this.getShortcut("CodeCompletion");
            this.forwardStroke = this.getShortcut("Forward");
            this.backStroke = this.getShortcut("Back");
            this.setFocusTraversalKeysEnabled(false);
            this.putClientProperty("JTextField.variant", "search");
            this.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    super.insertString(offs, str, a);
                    if (str != null && str.length() > 1) {
                        ChooseByNameBase.this.handlePaste(str);
                    }
                }
            });
        }

        @Nullable
        private KeyStroke getShortcut(String actionCodeCompletion) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionCodeCompletion).getShortcuts()) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            }
            return null;
        }

        public void calcData(DataKey key2, @NotNull DataSink sink) {
            if (sink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "calcData"));
            }
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.equals(key2)) {
                if (ChooseByNameBase.this.myDropdownPopup != null && ChooseByNameBase.this.myDropdownPopup.isVisible()) {
                    sink.put(key2, (Object)ChooseByNameBase.this.myDropdownPopup);
                }
            } else if (LangDataKeys.PARENT_POPUP.equals(key2) && ChooseByNameBase.this.myTextPopup != null && ChooseByNameBase.this.myTextPopup.isVisible()) {
                sink.put(key2, (Object)ChooseByNameBase.this.myTextPopup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyEvent(@NotNull KeyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "processKeyEvent"));
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (this.myCompletionKeyStroke != null && keyStroke.equals(this.myCompletionKeyStroke)) {
                this.completionKeyStrokeHappened = true;
                e.consume();
                String pattern = ChooseByNameBase.this.getTrimmedText();
                int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                ChooseByNameBase.this.myHistory.add(Pair.create((Object)pattern, (Object)oldPos));
                Runnable postRunnable = () -> this.fillInCommonPrefix(pattern);
                ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), postRunnable);
                return;
            }
            if (this.backStroke != null && keyStroke.equals(this.backStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myHistory.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair last = (Pair)ChooseByNameBase.this.myHistory.remove(ChooseByNameBase.this.myHistory.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)last.first);
                    ChooseByNameBase.this.myFuture.add(Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), null);
                }
                return;
            }
            if (this.forwardStroke != null && keyStroke.equals(this.forwardStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myFuture.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair next = (Pair)ChooseByNameBase.this.myFuture.remove(ChooseByNameBase.this.myFuture.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)next.first);
                    ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), null);
                }
                return;
            }
            int position = ChooseByNameBase.this.myTextField.getCaretPosition();
            int code2 = keyStroke.getKeyCode();
            int modifiers = keyStroke.getModifiers();
            try {
                super.processKeyEvent(e);
            }
            catch (NullPointerException e1) {
                if (!Patches.SUN_BUG_ID_6322854) {
                    throw e1;
                }
            }
            finally {
                if ((code2 == 38 || code2 == 40) && modifiers == 0) {
                    ChooseByNameBase.this.myTextField.setCaretPosition(position);
                }
            }
        }

        private void fillInCommonPrefix(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "fillInCommonPrefix"));
            }
            List<String> list2 = ChooseByNameBase.this.myProvider.filterNames(ChooseByNameBase.this, ChooseByNameBase.this.getNames(ChooseByNameBase.this.myCheckBox.isSelected()), pattern);
            if (list2.isEmpty()) {
                return;
            }
            if (this.isComplexPattern(pattern)) {
                return;
            }
            String oldText = ChooseByNameBase.this.getTrimmedText();
            int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
            String commonPrefix = null;
            if (!list2.isEmpty()) {
                for (String name2 : list2) {
                    String string = name2.toLowerCase();
                    if (commonPrefix == null) {
                        commonPrefix = string;
                        continue;
                    }
                    while (!commonPrefix.isEmpty() && !string.startsWith(commonPrefix)) {
                        commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
                    }
                    if (!commonPrefix.isEmpty()) continue;
                    break;
                }
                commonPrefix = list2.get(0).substring(0, commonPrefix.length());
                for (int i2 = 1; i2 < list2.size(); ++i2) {
                    String string = list2.get(i2).substring(0, commonPrefix.length());
                    if (string.equals(commonPrefix)) continue;
                    commonPrefix = commonPrefix.toLowerCase();
                    break;
                }
            }
            if (commonPrefix == null) {
                commonPrefix = "";
            }
            if (!StringUtil.startsWithIgnoreCase((String)commonPrefix, (String)pattern)) {
                commonPrefix = pattern;
            }
            String newPattern = commonPrefix;
            ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
            ChooseByNameBase.this.myTextField.setText(newPattern);
            ChooseByNameBase.this.myTextField.setCaretPosition(newPattern.length());
            ChooseByNameBase.this.rebuildList(false);
        }

        private boolean isComplexPattern(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "isComplexPattern"));
            }
            if (pattern.indexOf(42) >= 0) {
                return true;
            }
            for (String s : ChooseByNameBase.this.myModel.getSeparators()) {
                if (!pattern.contains(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Point getBestPopupPosition() {
            Point point = new Point(ChooseByNameBase.this.myTextFieldPanel.getWidth(), this.getHeight());
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "getBestPopupPosition"));
            }
            return point;
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField", "paintComponent"));
            }
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paintComponent(g);
        }

        public boolean isCompletionKeyStroke() {
            return this.completionKeyStrokeHappened;
        }
    }

    private class ListUpdater {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private static final int DELAY = 10;
        private static final int MAX_BLOCKING_TIME = 30;
        private final List<ModelDiff.Cmd> myCommands = Collections.synchronizedList(new ArrayList());

        private ListUpdater() {
        }

        public void cancelAll() {
            this.myCommands.clear();
            this.myAlarm.cancelAllRequests();
        }

        public void appendToModel(@NotNull List<ModelDiff.Cmd> commands, final SelectionPolicy selection) {
            if (commands == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ListUpdater", "appendToModel"));
            }
            this.myAlarm.cancelAllRequests();
            this.myCommands.addAll(commands);
            if (this.myCommands.isEmpty() || ChooseByNameBase.this.checkDisposed()) {
                return;
            }
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (ChooseByNameBase.this.checkDisposed()) {
                        return;
                    }
                    long startTime = System.currentTimeMillis();
                    while (!ListUpdater.this.myCommands.isEmpty() && System.currentTimeMillis() - startTime < 30L) {
                        ModelDiff.Cmd cmd = (ModelDiff.Cmd)ListUpdater.this.myCommands.remove(0);
                        cmd.apply();
                    }
                    ChooseByNameBase.this.myList.setVisibleRowCount(Math.min(VISIBLE_LIST_SIZE_LIMIT, ChooseByNameBase.this.myList.getModel().getSize()));
                    if (!ListUpdater.this.myCommands.isEmpty()) {
                        ListUpdater.this.myAlarm.addRequest((Runnable)this, 10);
                    }
                    if (!ChooseByNameBase.this.checkDisposed()) {
                        ChooseByNameBase.this.showList();
                        ChooseByNameBase.this.myTextFieldPanel.repositionHint();
                        if (!ChooseByNameBase.this.myListModel.isEmpty()) {
                            ChooseByNameBase.this.applySelection(selection);
                        }
                    }
                }
            }, 10);
        }
    }

    public class JPanelProvider
    extends JPanel
    implements DataProvider {
        private JBPopup myHint = null;
        private boolean myFocusRequested = false;

        JPanelProvider() {
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                return ChooseByNameBase.this.myTextField.getText();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ChooseByNameBase.this.myModel.getHelpId();
            }
            if (ChooseByNameBase.this.myCalcElementsThread != null) {
                return null;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                Object element = ChooseByNameBase.this.getChosenElement();
                if (element instanceof PsiElement) {
                    return element;
                }
                if (element instanceof DataProvider) {
                    return ((DataProvider)element).getData(dataId);
                }
            } else if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                List<Object> chosenElements = ChooseByNameBase.this.getChosenElements();
                if (chosenElements != null) {
                    ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(chosenElements.size());
                    for (Object element : chosenElements) {
                        if (!(element instanceof PsiElement)) continue;
                        result2.add((PsiElement)element);
                    }
                    return PsiUtilCore.toPsiElementArray(result2);
                }
            } else {
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    return this.getBounds();
                }
                if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                    return ChooseByNameBase.this.myTextField.getText();
                }
            }
            return null;
        }

        public void registerHint(JBPopup h) {
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        public boolean focusRequested() {
            boolean focusRequested = this.myFocusRequested;
            this.myFocusRequested = false;
            return focusRequested;
        }

        @Override
        public void requestFocus() {
            this.myFocusRequested = true;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        public void hideHint() {
            if (this.myHint != null) {
                this.myHint.cancel();
            }
        }

        @Nullable
        public JBPopup getHint() {
            return this.myHint;
        }

        public void updateHint(PsiElement element) {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
            if (updateProcessor != null) {
                updateProcessor.updatePopup(element);
            }
        }

        public void repositionHint() {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupPositionManager.positionPopupInBestPosition(this.myHint, null, null);
        }
    }
}

