/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import org.jetbrains.annotations.NotNull;

class MatchResult {
    public final String elementName;
    final int matchingDegree;
    final boolean startMatch;

    MatchResult(String elementName, int matchingDegree, boolean startMatch) {
        this.elementName = elementName;
        this.matchingDegree = matchingDegree;
        this.startMatch = startMatch;
    }

    int compareWith(@NotNull MatchResult that, boolean preferStartMatches) {
        int startMatchResult;
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/ide/util/gotoByName/MatchResult", "compareWith"));
        }
        boolean start1 = this.startMatch;
        boolean start2 = that.startMatch;
        int n = start1 == start2 ? 0 : (startMatchResult = start1 ? -1 : 1);
        if (preferStartMatches && startMatchResult != 0) {
            return startMatchResult;
        }
        int degree2 = that.matchingDegree;
        int degree1 = this.matchingDegree;
        if (degree2 < degree1) {
            return -1;
        }
        if (degree2 > degree1) {
            return 1;
        }
        if (startMatchResult != 0) {
            return -startMatchResult;
        }
        return this.elementName.compareToIgnoreCase(that.elementName);
    }
}

