/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeViewUtil {
    private static final int SUBPACKAGE_LIMIT = 2;
    private static final Key<ConcurrentMap<PsiPackage, Boolean>> SHOULD_ABBREV_PACK_KEY = Key.create((String)"PACK_ABBREV_CACHE");

    private static boolean shouldAbbreviateName(PsiPackage aPackage) {
        Boolean ret;
        ConcurrentMap newMap;
        Project project2 = aPackage.getProject();
        ConcurrentMap map2 = (ConcurrentMap)project2.getUserData(SHOULD_ABBREV_PACK_KEY);
        if (map2 == null && (map2 = (ConcurrentMap)((UserDataHolderEx)project2).putUserDataIfAbsent(SHOULD_ABBREV_PACK_KEY, (Object)(newMap = ContainerUtil.createConcurrentWeakMap()))) == newMap) {
            PsiManagerEx.getInstanceEx(project2).registerRunnableToRunOnChange(() -> newMap.clear());
        }
        if ((ret = (Boolean)map2.get(aPackage)) != null) {
            return ret;
        }
        ret = TreeViewUtil.scanPackages(aPackage, 1);
        map2.put(aPackage, ret);
        return ret;
    }

    private static boolean scanPackages(@NotNull PsiPackage p, int packageNameOccurrencesFound) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/util/treeView/TreeViewUtil", "scanPackages"));
        }
        PsiPackage[] subPackages = p.getSubPackages();
        if ((packageNameOccurrencesFound += subPackages.length) > 2) {
            return true;
        }
        for (PsiPackage subPackage : subPackages) {
            if (!TreeViewUtil.scanPackages(subPackage, packageNameOccurrencesFound)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String calcAbbreviatedPackageFQName(@NotNull PsiPackage aPackage) {
        String packageName;
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/ide/util/treeView/TreeViewUtil", "calcAbbreviatedPackageFQName"));
        }
        StringBuilder name2 = new StringBuilder(aPackage.getName());
        for (PsiPackage parentPackage = aPackage.getParentPackage(); parentPackage != null && (packageName = parentPackage.getName()) != null && !packageName.isEmpty(); parentPackage = parentPackage.getParentPackage()) {
            name2.insert(0, ".");
            if (packageName.length() > 2 && TreeViewUtil.shouldAbbreviateName(parentPackage)) {
                name2.insert(0, packageName.substring(0, 1));
                continue;
            }
            name2.insert(0, packageName);
        }
        String string = name2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeViewUtil", "calcAbbreviatedPackageFQName"));
        }
        return string;
    }

    public static boolean isEmptyMiddlePackage(@NotNull PsiDirectory dir, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/util/treeView/TreeViewUtil", "isEmptyMiddlePackage"));
        }
        VirtualFile[] files = dir.getVirtualFile().getChildren();
        if (files.length == 0) {
            return false;
        }
        PsiManager manager = dir.getManager();
        int subpackagesCount = 0;
        int directoriesCount = 0;
        for (VirtualFile file2 : files) {
            PsiDirectory childDir;
            if (FileTypeManager.getInstance().isFileIgnored(file2)) continue;
            if (!file2.isDirectory()) {
                if (filter == null) {
                    return false;
                }
                PsiFile childFile = manager.findFile(file2);
                if (childFile != null && filter.shouldShow((PsiFileSystemItem)childFile)) {
                    return false;
                }
            }
            if ((childDir = manager.findDirectory(file2)) == null || filter != null && !filter.shouldShow((PsiFileSystemItem)childDir)) continue;
            if (strictlyEmpty && ++directoriesCount > 1) {
                return false;
            }
            if (JavaDirectoryService.getInstance().getPackage(childDir) == null) continue;
            ++subpackagesCount;
        }
        if (strictlyEmpty) {
            return directoriesCount == subpackagesCount && directoriesCount == 1;
        }
        return directoriesCount == subpackagesCount && directoriesCount > 0;
    }
}

