/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class BuildIcons {
    private static final Set<String> IMAGE_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"png", "gif", "jpg", "jpeg"});

    public static void main(String[] args) throws Exception {
        File root = new File("/Users/max/IDEA/out/classes/production/");
        MultiMap dimToPath = new MultiMap();
        BuildIcons.walk(root, (MultiMap<Couple<Integer>, String>)dimToPath, root);
        ArrayList keys = new ArrayList(dimToPath.keySet());
        Collections.sort(keys, (o1, o2) -> {
            int d0 = dimToPath.get(o2).size() - dimToPath.get(o1).size();
            if (d0 != 0) {
                return d0;
            }
            int d1 = (Integer)o1.first - (Integer)o2.first;
            if (d1 != 0) {
                return d1;
            }
            return (Integer)o1.second - (Integer)o2.second;
        });
        int total = 0;
        for (Couple key2 : keys) {
            Collection paths = dimToPath.get((Object)key2);
            System.out.println("------------------------   " + key2.first + "x" + key2.second + "  (total " + paths.size() + " icons) --------------------------------");
            for (String path : paths) {
                System.out.println(path);
                ++total;
            }
            System.out.println("");
        }
        System.out.println("Total icons: " + total);
    }

    private static void walk(File root, MultiMap<Couple<Integer>, String> dimToPath, File file2) throws IOException {
        if (file2.isDirectory()) {
            for (File child : file2.listFiles()) {
                BuildIcons.walk(root, dimToPath, child);
            }
        } else if (IMAGE_EXTENSIONS.contains(FileUtilRt.getExtension((String)file2.getName()))) {
            File target2;
            String relativePath = file2.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
            Image image = BuildIcons.loadImage(file2);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (height != width && (height > 100 || width > 100)) {
                target2 = new File("/Users/max/images/other", relativePath);
            } else {
                target2 = new File("/Users/max/images/icons", relativePath);
                dimToPath.putValue((Object)new Couple((Object)width, (Object)height), (Object)relativePath);
            }
            FileUtil.copy((File)file2, (File)target2);
        }
    }

    private static Image loadImage(File path) {
        Image image = Toolkit.getDefaultToolkit().createImage(path.getAbsolutePath());
        BuildIcons.waitForImage(image);
        return image;
    }

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(new Component(){});
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !mediatracker.isErrorID(1);
    }
}

