/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.annotations.NotNull;

public class ToggleDumbModeAction
extends DumbAwareAction {
    private static final Key<Boolean> DUMB = Key.create((String)"ToggleDumbModeAction");

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        if (ToggleDumbModeAction.isToggledDumb(project2)) {
            ToggleDumbModeAction.setToggledDumb(project2, false);
        } else {
            ToggleDumbModeAction.setToggledDumb(project2, true);
            DumbServiceImpl.getInstance(project2).queueTask(new DumbModeTask(){

                public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/ToggleDumbModeAction$1", "performInDumbMode"));
                    }
                    while (ToggleDumbModeAction.isToggledDumb(project2)) {
                        indicator.checkCanceled();
                        TimeoutUtil.sleep((long)100L);
                    }
                }
            });
        }
    }

    private static void setToggledDumb(Project project2, boolean value2) {
        project2.putUserData(DUMB, (Object)value2);
    }

    private static boolean isToggledDumb(Project project2) {
        return project2.getUserData(DUMB) == Boolean.TRUE;
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean dumb = DumbServiceImpl.getInstance(project2).isDumb();
        if (!dumb && ToggleDumbModeAction.isToggledDumb(project2)) {
            ToggleDumbModeAction.setToggledDumb(project2, false);
        }
        e.getPresentation().setEnabled(!dumb || ToggleDumbModeAction.isToggledDumb(project2));
        e.getPresentation().setText(dumb ? "Exit Dumb Mode" : "Enter Dumb Mode");
    }
}

