/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ActionsCollector", storages={@Storage(value="statistics.actions.xml", roamingType=RoamingType.DISABLED)})
public class ActionsCollector
implements PersistentStateComponent<State> {
    private State myState = new State();

    public ActionsCollector(final ActionManager manager) {
        manager.addAnActionListener(new AnActionListener(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                String id = manager.getId(action);
                if (id != null) {
                    ActionsCollector.this.record(id);
                }
            }
        });
    }

    public void record(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/internal/statistic/ActionsCollector", "record"));
        }
        State state = this.getState();
        if (state == null) {
            return;
        }
        String key2 = ConvertUsagesUtil.escapeDescriptorName(actionId);
        Integer count = state.myValues.get(key2);
        int value2 = count == null ? 1 : count + 1;
        state.myValues.put(key2, value2);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static ActionsCollector getInstance() {
        return (ActionsCollector)ApplicationManager.getApplication().getComponent(ActionsCollector.class);
    }

    static final class ActionUsagesCollector
    extends UsagesCollector {
        private static final GroupDescriptor GROUP = GroupDescriptor.create("Actions", 100.0);

        ActionUsagesCollector() {
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() {
            State state = ActionsCollector.getInstance().getState();
            assert (state != null);
            Set set2 = ContainerUtil.map2Set(state.myValues.entrySet(), e -> new UsageDescriptor((String)e.getKey(), (Integer)e.getValue()));
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ActionsCollector$ActionUsagesCollector", "getUsages"));
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP;
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ActionsCollector$ActionUsagesCollector", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="action", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();

        State() {
        }
    }
}

