/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.beans;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;

public class GroupDescriptor {
    public static final double DEFAULT_PRIORITY = 0.0;
    public static final double HIGHER_PRIORITY = 100.0;
    public static final double LOWER_PRIORITY = -100.0;
    private static final int MAX_ID_LENGTH = 30;
    private final String myId;
    private final double myPriority;

    public static GroupDescriptor create(String id) {
        return new GroupDescriptor(id, 0.0);
    }

    public static GroupDescriptor create(String id, double priority) {
        return new GroupDescriptor(id, priority);
    }

    private GroupDescriptor(String id, double priority) {
        if (StringUtil.isEmptyOrSpaces((String)id)) {
            throw new IllegalArgumentException("Invalid ID: '" + id + "'");
        }
        if (id.length() > 30) {
            Logger.getInstance(GroupDescriptor.class).error("ID too long: '" + id + "', truncated");
            id = id.substring(0, 30);
        }
        this.myId = ConvertUsagesUtil.ensureProperKey(id);
        this.myPriority = priority;
    }

    public String getId() {
        return this.myId;
    }

    public double getPriority() {
        return this.myPriority;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof GroupDescriptor && this.myId.equals(((GroupDescriptor)o).myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }
}

