/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class IdeInitialConfigUsageCollectors {

    private static abstract class Base
    extends UsagesCollector {
        private Base() {
        }

        protected abstract Set<UsageDescriptor> doGetUsages() throws CollectUsagesException;

        private static boolean shouldCount() {
            return IdeInitialConfigButtonUsages.getConfigImport() != IdeInitialConfigButtonUsages.ConfigImport.NO_INIT;
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
            if (!Base.shouldCount()) {
                Set<UsageDescriptor> set2 = Collections.emptySet();
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$Base", "getUsages"));
                }
                return set2;
            }
            Set<UsageDescriptor> set3 = this.doGetUsages();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$Base", "getUsages"));
            }
            return set3;
        }
    }

    public static class SelectedLAF
    extends Base {
        @Override
        protected Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            String laf = WelcomeWizardUtil.getWizardLAF();
            if (StringUtil.isEmpty((String)laf)) {
                return Collections.emptySet();
            }
            return Collections.singleton(new UsageDescriptor(laf, 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard:Selected LAF");
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$SelectedLAF", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    public static class SelectedKeymap
    extends Base {
        @Override
        protected Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            String keymapName = WelcomeWizardUtil.getWizardMacKeymap();
            if (StringUtil.isEmpty((String)keymapName)) {
                return Collections.emptySet();
            }
            return Collections.singleton(new UsageDescriptor(keymapName, 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard:Selected keymap");
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$SelectedKeymap", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    public static class DownloadedPlugins
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            Set<UsageDescriptor> set2 = IdeInitialConfigButtonUsages.getDownloadedPlugins().stream().map(pluginId -> new UsageDescriptor((String)pluginId, 1)).collect(Collectors.toSet());
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$DownloadedPlugins", "doGetUsages"));
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard:Downloaded plugins");
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$DownloadedPlugins", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    public static class DisabledPlugins
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            Set<UsageDescriptor> set2 = IdeInitialConfigButtonUsages.getPredefinedDisabledPlugins().stream().map(pluginDescriptor -> new UsageDescriptor((String)pluginDescriptor, 1)).collect(Collectors.toSet());
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$DisabledPlugins", "doGetUsages"));
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard:Disabled plugins");
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$DisabledPlugins", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    public static class SkipSteps
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            Set<UsageDescriptor> set2 = Collections.singleton(new UsageDescriptor(IdeInitialConfigButtonUsages.getSkipRemainingPressedScreen(), 1));
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$SkipSteps", "doGetUsages"));
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard:Skip remaining pressed");
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$SkipSteps", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    public static class ConfigImport
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            Set<UsageDescriptor> set2 = Collections.singleton(StatisticsUtilKt.getEnumUsage("import", IdeInitialConfigButtonUsages.getConfigImport()));
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$ConfigImport", "doGetUsages"));
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Import settings");
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeInitialConfigUsageCollectors$ConfigImport", "getGroupId"));
            }
            return groupDescriptor;
        }
    }
}

