/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IvyAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(IvyAttachSourceProvider.class);

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, PsiFile psiFile) {
        VirtualFile srcFile;
        String artifactName;
        VirtualFile jar = IvyAttachSourceProvider.getJarByPsiFile(psiFile);
        if (jar == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list2;
        }
        VirtualFile jarsDir = jar.getParent();
        if (jarsDir == null || !jarsDir.getName().equals("jars")) {
            List<AttachSourcesProvider.AttachSourcesAction> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list3;
        }
        final VirtualFile artifactDir = jarsDir.getParent();
        if (artifactDir == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list4;
        }
        String jarNameWithoutExt = jar.getNameWithoutExtension();
        if (!jarNameWithoutExt.startsWith(artifactName = artifactDir.getName()) || !jarNameWithoutExt.substring(artifactName.length()).startsWith("-")) {
            List<AttachSourcesProvider.AttachSourcesAction> list5 = Collections.emptyList();
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list5;
        }
        String version = jarNameWithoutExt.substring(artifactName.length() + 1);
        VirtualFile propertiesFile = artifactDir.findChild("ivydata-" + version + ".properties");
        if (propertiesFile == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list6 = Collections.emptyList();
            if (list6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list6;
        }
        final Library library = IvyAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntries);
        if (library == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list7 = Collections.emptyList();
            if (list7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list7;
        }
        final String sourceFileName = artifactName + '-' + version + "-sources.jar";
        final VirtualFile sources = artifactDir.findChild("sources");
        if (sources != null && (srcFile = sources.findChild(sourceFileName)) != null) {
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
            if (jarRoot == null || ArrayUtil.contains((Object)jarRoot, (Object[])library.getFiles(OrderRootType.SOURCES))) {
                List<AttachSourcesProvider.AttachSourcesAction> list8 = Collections.emptyList();
                if (list8 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
                }
                return list8;
            }
            Set<AttachSourcesProvider.AttachSourcesAction> set2 = Collections.singleton(new AbstractAttachSourceProvider.AttachExistingSourceAction(jarRoot, library, "Attache sources from Ivy repository"));
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return set2;
        }
        String url = IvyAttachSourceProvider.extractUrl(propertiesFile, artifactName);
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            List<AttachSourcesProvider.AttachSourcesAction> list9 = Collections.emptyList();
            if (list9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
            }
            return list9;
        }
        Set<AttachSourcesProvider.AttachSourcesAction> set3 = Collections.singleton(new AbstractAttachSourceProvider.DownloadSourcesAction(psiFile.getProject(), "Downloading Ivy Sources", url){

            @Override
            protected void storeFile(byte[] content) {
                try {
                    VirtualFile existingSourcesFolder = sources;
                    if (existingSourcesFolder == null) {
                        existingSourcesFolder = artifactDir.createChildDirectory((Object)this, "sources");
                    }
                    VirtualFile srcFile = existingSourcesFolder.createChildData((Object)this, sourceFileName);
                    srcFile.setBinaryContent(content);
                    IvyAttachSourceProvider.this.addSourceFile(JarFileSystem.getInstance().getJarRootForLocalFile(srcFile), library);
                }
                catch (IOException e) {
                    String message2 = "Failed to save " + artifactDir.getPath() + "/sources/" + sourceFileName;
                    new Notification(this.myMessageGroupId, "IO Error", message2, NotificationType.ERROR).notify(this.myProject);
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
        }
        return set3;
    }

    @Nullable
    private static String extractUrl(VirtualFile properties, String artifactName) {
        String prefix = "artifact:" + artifactName + "#source#jar#";
        try {
            Properties p = new Properties();
            p.load(new StringReader(VfsUtilCore.loadText((VirtualFile)properties)));
            for (Object o : p.keySet()) {
                String key2 = o.toString();
                if (key2 == null || !key2.startsWith(prefix) || !key2.endsWith(".location")) continue;
                return p.getProperty(key2);
            }
        }
        catch (Exception e) {
            LOG.debug(properties.getPath(), (Throwable)e);
        }
        return null;
    }
}

