/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.CommonBundle;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class JarRepositoryManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler");
    private static final String MAVEN_REPOSITORY_MACRO = "$MAVEN_REPOSITORY$";
    private static final String DEFAULT_REPOSITORY_PATH = ".m2/repository";
    private static volatile int ourTasksInProgress;
    private static volatile File ourLocalRepositoryPath;

    public static boolean hasRunningTasks() {
        return ourTasksInProgress > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project2, @Nullable String initialFilter, JComponent parentComponent) {
        String copyTo2;
        boolean includeTransitiveDependencies;
        boolean attachJavaDoc;
        boolean attachSources;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "chooseLibraryAndDownload"));
        }
        RepositoryAttachDialog dialog2 = new RepositoryAttachDialog(project2, initialFilter);
        dialog2.setTitle("Download Library From Maven Repository");
        dialog2.show();
        if (dialog2.getExitCode() != 0) {
            return null;
        }
        String coord = dialog2.getCoordinateText();
        NewLibraryConfiguration config = JarRepositoryManager.resolveAndDownload(project2, coord, attachSources = dialog2.getAttachSources(), attachJavaDoc = dialog2.getAttachJavaDoc(), includeTransitiveDependencies = dialog2.getIncludeTransitiveDependencies(), copyTo2 = dialog2.getDirectoryPath(), RemoteRepositoriesConfiguration.getInstance(project2).getRepositories());
        if (config == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)("No files were downloaded for " + coord), (String)CommonBundle.getErrorTitle());
        }
        return config;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, boolean includeTransitiveDependencies, String copyTo2, Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "resolveAndDownload"));
        }
        RepositoryLibraryProperties props = new RepositoryLibraryProperties(coord, includeTransitiveDependencies);
        final Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(project2, props, attachSources, attachJavaDoc, copyTo2, repositories);
        if (roots != null && !roots.isEmpty()) {
            JarRepositoryManager.notifyArtifactsDownloaded(project2, roots);
            return new NewLibraryConfiguration(RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)props).getDisplayName(props.getVersion()), RepositoryLibraryType.getInstance(), (LibraryProperties)props){

                @Override
                public void addRoots(@NotNull LibraryEditor editor) {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/JarRepositoryManager$1", "addRoots"));
                    }
                    editor.addRoots(roots);
                }
            };
        }
        return null;
    }

    @NotNull
    public static File getLocalRepositoryPath() {
        File repoPath = ourLocalRepositoryPath;
        if (repoPath != null) {
            File file2 = repoPath;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/JarRepositoryManager", "getLocalRepositoryPath"));
            }
            return file2;
        }
        String expanded = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(MAVEN_REPOSITORY_MACRO);
        if (!MAVEN_REPOSITORY_MACRO.equals(expanded) && (repoPath = new File(expanded)).exists()) {
            ourLocalRepositoryPath = repoPath;
            File file3 = repoPath;
            if (file3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/JarRepositoryManager", "getLocalRepositoryPath"));
            }
            return file3;
        }
        String userHome = System.getProperty("user.home", null);
        ourLocalRepositoryPath = repoPath = userHome != null ? new File(userHome, DEFAULT_REPOSITORY_PATH) : new File(DEFAULT_REPOSITORY_PATH);
        File file4 = repoPath;
        if (file4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/JarRepositoryManager", "getLocalRepositoryPath"));
        }
        return file4;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo2, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "loadDependenciesModal"));
        }
        if (libraryProps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryProps", "com/intellij/jarRepository/JarRepositoryManager", "loadDependenciesModal"));
        }
        return JarRepositoryManager.loadDependenciesImpl(project2, libraryProps, loadSources, loadJavadoc, copyTo2, repositories, true);
    }

    @Deprecated
    public static Collection<OrderRoot> loadDependencies(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo2, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "loadDependencies"));
        }
        if (libraryProps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryProps", "com/intellij/jarRepository/JarRepositoryManager", "loadDependencies"));
        }
        return JarRepositoryManager.loadDependenciesImpl(project2, libraryProps, loadSources, loadJavadoc, copyTo2, repositories, false);
    }

    private static Collection<OrderRoot> loadDependenciesImpl(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo2, @Nullable Collection<RemoteRepositoryDescription> repositories, boolean modal) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "loadDependenciesImpl"));
        }
        if (libraryProps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryProps", "com/intellij/jarRepository/JarRepositoryManager", "loadDependenciesImpl"));
        }
        JpsMavenRepositoryLibraryDescriptor libDescriptor = libraryProps.getRepositoryLibraryDescriptor();
        if (libDescriptor.getMavenId() != null) {
            if (repositories == null || repositories.isEmpty()) {
                repositories = RemoteRepositoriesConfiguration.getInstance(project2).getRepositories();
            }
            if (!repositories.isEmpty()) {
                EnumSet<ArtifactKind> kinds = EnumSet.of(ArtifactKind.ARTIFACT);
                if (loadSources) {
                    kinds.add(ArtifactKind.SOURCES);
                }
                if (loadJavadoc) {
                    kinds.add(ArtifactKind.JAVADOC);
                }
                try {
                    if (modal) {
                        return JarRepositoryManager.submitModalJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(libDescriptor, kinds, repositories, copyTo2));
                    }
                    return JarRepositoryManager.submitBackgroundJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(libDescriptor, kinds, repositories, copyTo2)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return Collections.emptyList();
    }

    public static void loadDependenciesAsync(@NotNull Project project2, RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo2, Consumer<Collection<OrderRoot>> resultProcessor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "loadDependenciesAsync"));
        }
        EnumSet<ArtifactKind> kinds = EnumSet.of(ArtifactKind.ARTIFACT);
        if (loadSources) {
            kinds.add(ArtifactKind.SOURCES);
        }
        if (loadJavadoc) {
            kinds.add(ArtifactKind.JAVADOC);
        }
        JarRepositoryManager.loadDependenciesAsync(project2, libraryProps.getRepositoryLibraryDescriptor(), kinds, repos, copyTo2, resultProcessor);
    }

    public static void loadDependenciesAsync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo2, Consumer<Collection<OrderRoot>> resultProcessor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/JarRepositoryManager", "loadDependenciesAsync"));
        }
        if (repos == null || repos.isEmpty()) {
            repos = RemoteRepositoriesConfiguration.getInstance(project2).getRepositories();
        }
        JarRepositoryManager.submitBackgroundJob(project2, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, repos, copyTo2).andThen(roots -> {
            resultProcessor.accept((Collection<OrderRoot>)roots);
            return roots;
        }));
    }

    public static void getAvailableVersionsAsync(Project project2, RepositoryLibraryDescription libraryDescription, Consumer<Collection<String>> resultProcessor) {
        List<RemoteRepositoryDescription> repos = RemoteRepositoriesConfiguration.getInstance(project2).getRepositories();
        JarRepositoryManager.submitBackgroundJob(project2, "Looking up available versions for " + libraryDescription.getDisplayName(), new VersionResolveJob(libraryDescription, repos).andThen(versions -> {
            resultProcessor.accept((Collection<String>)versions);
            return versions;
        }));
    }

    @NotNull
    public static Future<Collection<String>> getAvailableVersions(Project project2, RepositoryLibraryDescription libraryDescription) {
        List<RemoteRepositoryDescription> repos = RemoteRepositoriesConfiguration.getInstance(project2).getRepositories();
        Future<Collection<String>> future2 = JarRepositoryManager.submitBackgroundJob(project2, "Looking up available versions for " + libraryDescription.getDisplayName(), new VersionResolveJob(libraryDescription, repos));
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/JarRepositoryManager", "getAvailableVersions"));
        }
        return future2;
    }

    private static void notifyArtifactsDownloaded(Project project2, Collection<OrderRoot> roots) {
        StringBuilder sb = new StringBuilder();
        String title = "The following files were downloaded:";
        sb.append("<ol>");
        for (OrderRoot root : roots) {
            sb.append("<li>");
            sb.append(root.getFile().getName());
            sb.append("</li>");
        }
        sb.append("</ol>");
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", sb.toString(), NotificationType.INFORMATION), (Project)project2);
    }

    public static void searchArtifacts(final Project project2, String coord, final Consumer<Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        if (coord == null || coord.length() == 0) {
            return;
        }
        final RepositoryArtifactDescription template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, "jar", null, coord, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(coord, true), "jar", null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$2", "run"));
                }
                ArrayList<Pair> resultList = new ArrayList<Pair>();
                try {
                    for (String serviceUrl : MavenRepositoryServicesManager.getServiceUrls(project2)) {
                        try {
                            List<RepositoryArtifactDescription> artifacts = MavenRepositoryServicesManager.findArtifacts(template, serviceUrl);
                            if (artifacts.isEmpty()) continue;
                            List<RemoteRepositoryDescription> repositories = MavenRepositoryServicesManager.getRepositories(serviceUrl);
                            THashMap map2 = new THashMap();
                            for (RemoteRepositoryDescription repository : repositories) {
                                map2.put(repository.getId(), repository);
                            }
                            for (RepositoryArtifactDescription artifact : artifacts) {
                                RemoteRepositoryDescription repository = (RemoteRepositoryDescription)map2.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.accept(resultList));
                }
            }
        });
    }

    public static void searchRepositories(Project project2, final Collection<String> serviceUrls, final Processor<Collection<RemoteRepositoryDescription>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$3", "run"));
                }
                Ref result2 = Ref.create(Collections.emptyList());
                try {
                    ArrayList<RemoteRepositoryDescription> repoList = new ArrayList<RemoteRepositoryDescription>();
                    for (String url : serviceUrls) {
                        List<RemoteRepositoryDescription> repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories(url);
                        }
                        catch (Exception ex) {
                            LOG.warn("Accessing Service at: " + url, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result2.set(repoList);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(result2.get()));
                }
            }
        });
    }

    @Nullable
    private static <T> T submitModalJob(@Nullable Project project2, String title, final Function<ProgressIndicator, T> job) {
        final Ref result2 = Ref.create(null);
        new Task.Modal(project2, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$4", "run"));
                }
                try {
                    ourTasksInProgress++;
                    result2.set(job.apply(indicator));
                }
                finally {
                    ourTasksInProgress--;
                }
            }
        }.queue();
        return (T)result2.get();
    }

    private static <T> Future<T> submitBackgroundJob(@Nullable Project project2, String title, Function<ProgressIndicator, T> job) {
        ModalityState startModality = ModalityState.defaultModalityState();
        return JobExecutor.INSTANCE.submit(() -> {
            try {
                ++ourTasksInProgress;
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(startModality);
                Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$null$2(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
                return object;
            }
            catch (ProcessCanceledException indicator) {
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            finally {
                --ourTasksInProgress;
            }
            return null;
        });
    }

    private static Collection<String> lookupVersionsImpl(String groupId, String artifactId, ArtifactRepositoryManager manager) throws Exception {
        try {
            List result2 = manager.getAvailableVersions(groupId, artifactId, "[0,)", ArtifactKind.ARTIFACT);
            return result2.stream().sorted(Comparator.reverseOrder()).map(Version::toString).collect(Collectors.toCollection(() -> new ArrayList(result2.size())));
        }
        catch (TransferCancelledException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    private static Function<ProgressIndicator, Collection<OrderRoot>> newOrderRootResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories, final @Nullable String copyTo2) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/jarRepository/JarRepositoryManager", "newOrderRootResolveJob"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/jarRepository/JarRepositoryManager", "newOrderRootResolveJob"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager", "newOrderRootResolveJob"));
        }
        return new LibraryResolveJob(desc, kinds, repositories).andThen(resolved -> resolved.isEmpty() ? Collections.emptyList() : (Collection)new WriteAction<Collection<OrderRoot>>(){

            protected void run(@NotNull Result<Collection<OrderRoot>> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jarRepository/JarRepositoryManager$5", "run"));
                }
                result2.setResult((Object)JarRepositoryManager.createRoots(resolved, copyTo2));
            }
        }.execute().getResultObject());
    }

    private static Collection<OrderRoot> createRoots(@NotNull Collection<Artifact> artifacts, @Nullable String copyTo2) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/jarRepository/JarRepositoryManager", "createRoots"));
        }
        ArrayList<OrderRoot> result2 = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Artifact each : artifacts) {
            try {
                File repoFile;
                File toFile = repoFile = each.getFile();
                if (copyTo2 != null) {
                    toFile = new File(copyTo2, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)toFile.getPath())));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file2 = manager.refreshAndFindFileByUrl(url);
                if (file2 == null) continue;
                OrderRootType rootType = ArtifactKind.JAVADOC.getClassifier().equals(each.getClassifier()) ? JavadocOrderRootType.getInstance() : (ArtifactKind.SOURCES.getClassifier().equals(each.getClassifier()) ? OrderRootType.SOURCES : OrderRootType.CLASSES);
                result2.add(new OrderRoot(file2, rootType));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return result2;
    }

    private static /* synthetic */ Object lambda$null$2(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription myDesc;

        public VersionResolveJob(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
            if (repositoryLibraryDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryLibraryDescription", "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob", "<init>"));
            }
            super(repositories);
            this.myDesc = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + this.myDesc.getDisplayName() + " versions";
        }

        @Override
        protected Collection<String> perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
            return JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager);
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor myDesc;
        @NotNull
        private final Set<ArtifactKind> myKinds;

        public LibraryResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob", "<init>"));
            }
            if (kinds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob", "<init>"));
            }
            super(repositories);
            this.myDesc = desc;
            this.myKinds = kinds;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.myDesc.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.myDesc).getDisplayName();
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
            String version = this.myDesc.getVersion();
            try {
                return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), version, this.myKinds, this.myDesc.isIncludeTransitiveDependencies());
            }
            catch (TransferCancelledException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (RepositoryOfflineException e) {
                throw e;
            }
            catch (Exception e) {
                String resolvedVersion = this.resolveVersion(manager, version);
                if (Comparing.equal((String)version, (String)resolvedVersion)) {
                    throw e;
                }
                try {
                    return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), resolvedVersion, this.myKinds, this.myDesc.isIncludeTransitiveDependencies());
                }
                catch (TransferCancelledException e1) {
                    throw new ProcessCanceledException((Throwable)e1);
                }
            }
        }

        @Nullable
        private String resolveVersion(ArtifactRepositoryManager manager, String version) throws Exception {
            boolean isLatest = "LATEST".equals(version);
            boolean isRelease = "RELEASE".equals(version);
            if (isLatest || isRelease) {
                try {
                    for (String ver : JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager)) {
                        if (isRelease && ver.endsWith("-SNAPSHOT")) continue;
                        return ver;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Got unexpected exception while resolving artifact versions", (Throwable)e);
                }
            }
            return version;
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Collection<RemoteRepositoryDescription> myRepositories;

        public AetherJob(@NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$AetherJob", "<init>"));
            }
            this.myRepositories = repositories;
        }

        protected boolean canStart() {
            return !this.myRepositories.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator indicator) {
            if (this.canStart()) {
                indicator.setText(this.getProgressText());
                indicator.setIndeterminate(true);
                ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
                for (RemoteRepositoryDescription repository : this.myRepositories) {
                    remotes.add(ArtifactRepositoryManager.createRemoteRepository((String)repository.getId(), (String)repository.getUrl()));
                }
                try {
                    return this.perform(indicator, new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), remotes, new ProgressConsumer(){

                        public void consume(String message2) {
                            indicator.setText(message2);
                        }

                        public boolean isCanceled() {
                            return indicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.getDefaultResult();
        }

        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();
    }

    private static class JobExecutor {
        static final ExecutorService INSTANCE = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"RemoteLibraryDownloader");

        private JobExecutor() {
        }
    }
}

