/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteRepositoriesConfiguration", storages={@Storage(value="jarRepositories.xml")})
public class RemoteRepositoriesConfiguration
implements PersistentStateComponent<State> {
    private final List<RemoteRepositoryDescription> myRepositories = new SmartList();

    public RemoteRepositoriesConfiguration() {
        this(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
    }

    public RemoteRepositoriesConfiguration(Collection<RemoteRepositoryDescription> repos) {
        this.myRepositories.addAll(repos);
    }

    @NotNull
    public static RemoteRepositoriesConfiguration getInstance(Project project2) {
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = (RemoteRepositoriesConfiguration)ServiceManager.getService((Project)project2, RemoteRepositoriesConfiguration.class);
        if (remoteRepositoriesConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RemoteRepositoriesConfiguration", "getInstance"));
        }
        return remoteRepositoriesConfiguration;
    }

    @NotNull
    public List<RemoteRepositoryDescription> getRepositories() {
        List<RemoteRepositoryDescription> list2 = Collections.unmodifiableList(this.myRepositories);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RemoteRepositoriesConfiguration", "getRepositories"));
        }
        return list2;
    }

    public void resetToDefault() {
        this.setRepositories(Collections.emptyList());
    }

    public void setRepositories(@NotNull List<RemoteRepositoryDescription> repos) {
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "com/intellij/jarRepository/RemoteRepositoriesConfiguration", "setRepositories"));
        }
        this.myRepositories.clear();
        this.myRepositories.addAll(repos.isEmpty() ? RemoteRepositoryDescription.DEFAULT_REPOSITORIES : repos);
    }

    @Nullable
    public State getState() {
        return new State(this.myRepositories);
    }

    public void loadState(State state) {
        SmartList loaded = new SmartList();
        if (state.data != null) {
            for (State.Repo repo : state.data) {
                loaded.add(new RemoteRepositoryDescription(repo.id, repo.name, repo.url));
            }
        }
        this.setRepositories((List<RemoteRepositoryDescription>)loaded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoriesConfiguration that = (RemoteRepositoriesConfiguration)o;
        return this.myRepositories.equals(that.myRepositories);
    }

    public int hashCode() {
        return this.myRepositories.hashCode();
    }

    static class State {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTypes={Repo.class})
        @NotNull
        public final List<Repo> data = new SmartList();

        public State() {
            this(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
        }

        public State(List<RemoteRepositoryDescription> repos) {
            for (RemoteRepositoryDescription repository : repos) {
                this.data.add(new Repo(repository.getId(), repository.getName(), repository.getUrl()));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.data.equals(state.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        @Tag(value="remote-repository")
        static class Repo {
            public String id;
            public String name;
            public String url;

            public Repo() {
            }

            public Repo(String id, String name2, String url) {
                this.id = id;
                this.name = name2;
                this.url = url;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Repo repo = (Repo)o;
                if (this.id != null ? !this.id.equals(repo.id) : repo.id != null) {
                    return false;
                }
                if (this.name != null ? !this.name.equals(repo.name) : repo.name != null) {
                    return false;
                }
                return !(this.url != null ? !this.url.equals(repo.url) : repo.url != null);
            }

            public int hashCode() {
                int result2 = this.id != null ? this.id.hashCode() : 0;
                result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
                result2 = 31 * result2 + (this.url != null ? this.url.hashCode() : 0);
                return result2;
            }
        }
    }
}

