/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryAttachDialog
extends DialogWrapper {
    @NonNls
    private static final String PROPERTY_DOWNLOAD_TO_PATH = "Downloaded.Files.Path";
    @NonNls
    private static final String PROPERTY_DOWNLOAD_TO_PATH_ENABLED = "Downloaded.Files.Path.Enabled";
    @NonNls
    private static final String PROPERTY_ATTACH_JAVADOC = "Repository.Attach.JavaDocs";
    @NonNls
    private static final String PROPERTY_ATTACH_SOURCES = "Repository.Attach.Sources";
    private final Project myProject;
    private JBLabel myInfoLabel;
    private JCheckBox myJavaDocCheckBox;
    private JCheckBox mySourcesCheckBox;
    private AsyncProcessIcon myProgressIcon;
    private ComboboxWithBrowseButton myComboComponent;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myDirectoryField;
    private JBCheckBox myDownloadToCheckBox;
    private JBLabel myCaptionLabel;
    private JBCheckBox myIncludeTransitiveDepsCheckBox;
    private final JComboBox myCombobox;
    private final Map<String, RepositoryArtifactDescription> myCoordinates;
    private final List<String> myShownItems;
    private final String myDefaultDownloadFolder;
    private String myFilterString;
    private boolean myInUpdate;

    public RepositoryAttachDialog(@NotNull Project project2, @Nullable String initialFilter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryAttachDialog", "<init>"));
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myCoordinates = ContainerUtil.newTroveMap();
        this.myShownItems = ContainerUtil.newArrayList();
        this.myProject = project2;
        this.myProgressIcon.suspend();
        this.myCaptionLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.escapeXml((String)"keyword or class name to search by or exact Maven coordinates, i.e. 'spring', 'Logger' or 'ant:ant-junit:1.6.5'")));
        this.myInfoLabel.setPreferredSize(new Dimension(this.myInfoLabel.getFontMetrics(this.myInfoLabel.getFont()).stringWidth("Showing: 1000"), this.myInfoLabel.getPreferredSize().height));
        this.myComboComponent.setButtonIcon(AllIcons.Actions.Menu_find);
        this.myComboComponent.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryAttachDialog.this.performSearch();
            }
        });
        this.myCombobox = this.myComboComponent.getComboBox();
        this.myCombobox.setModel(new CollectionComboBoxModel(this.myShownItems, null));
        this.myCombobox.setEditable(true);
        JTextField textField = (JTextField)this.myCombobox.getEditor().getEditorComponent();
        textField.setColumns(20);
        if (initialFilter != null) {
            textField.setText(initialFilter);
        }
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (RepositoryAttachDialog.this.myProgressIcon.isDisposed()) {
                        return;
                    }
                    RepositoryAttachDialog.this.updateComboboxSelection(false);
                });
            }
        });
        this.myCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean popupVisible = RepositoryAttachDialog.this.myCombobox.isPopupVisible();
                if (!(RepositoryAttachDialog.this.myInUpdate || popupVisible && !RepositoryAttachDialog.this.myCoordinates.isEmpty())) {
                    RepositoryAttachDialog.this.performSearch();
                } else {
                    String item = (String)RepositoryAttachDialog.this.myCombobox.getSelectedItem();
                    if (StringUtil.isNotEmpty((String)item)) {
                        ((JTextField)RepositoryAttachDialog.this.myCombobox.getEditor().getEditorComponent()).setText(item);
                    }
                }
            }
        });
        VirtualFile baseDir = !this.myProject.isDefault() ? this.myProject.getBaseDir() : null;
        this.myDefaultDownloadFolder = baseDir != null ? FileUtil.toSystemDependentName((String)(baseDir.getPath() + "/lib")) : "";
        PropertiesComponent storage2 = PropertiesComponent.getInstance((Project)this.myProject);
        this.myDownloadToCheckBox.setSelected(storage2.isTrueValue(PROPERTY_DOWNLOAD_TO_PATH_ENABLED));
        this.myDirectoryField.setText(StringUtil.notNullize((String)StringUtil.nullize((String)storage2.getValue(PROPERTY_DOWNLOAD_TO_PATH)), (String)this.myDefaultDownloadFolder));
        this.myDirectoryField.setEnabled(this.myDownloadToCheckBox.isSelected());
        this.myDownloadToCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryAttachDialog.this.myDirectoryField.setEnabled(RepositoryAttachDialog.this.myDownloadToCheckBox.isSelected());
            }
        });
        this.myJavaDocCheckBox.setSelected(storage2.isTrueValue(PROPERTY_ATTACH_JAVADOC));
        this.mySourcesCheckBox.setSelected(storage2.isTrueValue(PROPERTY_ATTACH_SOURCES));
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.putUserData(FileChooserDialog.PREFER_LAST_OVER_TO_SELECT, (Object)Boolean.TRUE);
        this.myDirectoryField.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, descriptor);
        this.updateInfoLabel();
        this.init();
    }

    public boolean getAttachJavaDoc() {
        return this.myJavaDocCheckBox.isSelected();
    }

    public boolean getAttachSources() {
        return this.mySourcesCheckBox.isSelected();
    }

    public boolean getIncludeTransitiveDependencies() {
        return this.myIncludeTransitiveDepsCheckBox.isSelected();
    }

    @Nullable
    public String getDirectoryPath() {
        return this.myDownloadToCheckBox.isSelected() ? this.myDirectoryField.getText() : null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCombobox;
    }

    private void updateComboboxSelection(boolean force) {
        boolean filtered;
        boolean itemSelected;
        String prevFilter = this.myFilterString;
        JTextComponent field = (JTextComponent)this.myCombobox.getEditor().getEditorComponent();
        int caret = field.getCaretPosition();
        this.myFilterString = field.getText();
        if (!force && Comparing.equal((String)this.myFilterString, (String)prevFilter)) {
            return;
        }
        int prevSize = this.myShownItems.size();
        this.myShownItems.clear();
        this.myInUpdate = true;
        boolean bl = itemSelected = this.myCoordinates.containsKey(this.myFilterString) && Comparing.strEqual((String)((String)this.myCombobox.getSelectedItem()), (String)this.myFilterString, (boolean)false);
        if (itemSelected) {
            this.myShownItems.addAll(this.myCoordinates.keySet());
            filtered = false;
        } else {
            String[] parts = this.myFilterString.split(" ");
            block0: for (String coordinate : this.myCoordinates.keySet()) {
                for (String part : parts) {
                    if (!StringUtil.containsIgnoreCase((String)coordinate, (String)part)) continue block0;
                }
                this.myShownItems.add(coordinate);
            }
            boolean bl2 = filtered = !this.myShownItems.isEmpty();
            if (!filtered) {
                this.myShownItems.addAll(this.myCoordinates.keySet());
            }
            this.myCombobox.setSelectedItem(null);
        }
        ArrayList<LibItem> items = new ArrayList<LibItem>(this.myShownItems.size());
        for (String coord : this.myShownItems) {
            items.add(new LibItem(coord));
        }
        Collections.sort(items, (o1, o2) -> Comparing.compare((Comparable)o1, (Comparable)o2));
        this.myShownItems.clear();
        for (LibItem it : items) {
            this.myShownItems.add(it.coord);
        }
        ((CollectionComboBoxModel)this.myCombobox.getModel()).update();
        this.myInUpdate = false;
        field.setText(this.myFilterString);
        field.setCaretPosition(caret);
        this.updateInfoLabel();
        if (filtered) {
            if (prevSize < 10 && this.myShownItems.size() > prevSize && this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(false);
            }
            if (!this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(true);
            }
        }
    }

    private boolean performSearch() {
        String text2 = this.getCoordinateText();
        if (this.myProgressIcon.isRunning() || StringUtil.isEmptyOrSpaces((String)text2) || this.myCoordinates.containsKey(text2)) {
            return false;
        }
        this.myProgressIcon.resume();
        JarRepositoryManager.searchArtifacts(this.myProject, text2, pairs -> {
            if (this.myProgressIcon.isDisposed()) {
                return;
            }
            this.myProgressIcon.suspend();
            int prevSize = this.myCoordinates.size();
            for (Pair pair2 : pairs) {
                RepositoryArtifactDescription artifact = (RepositoryArtifactDescription)pair2.first;
                this.myCoordinates.put(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), artifact);
            }
            this.updateComboboxSelection(prevSize != this.myCoordinates.size());
            this.setOKActionEnabled(true);
        });
        return true;
    }

    private void updateInfoLabel() {
        this.myInfoLabel.setText("<html>Found: " + this.myCoordinates.size() + "<br>Showing: " + this.myCombobox.getModel().getSize() + "</html>");
    }

    protected ValidationInfo doValidate() {
        File dir;
        if (!this.isValidCoordinateSelected()) {
            return new ValidationInfo("Please enter valid coordinate, discover it or select one from the list", (JComponent)this.myCombobox);
        }
        if (this.myDownloadToCheckBox.isSelected() && (!(dir = new File(this.myDirectoryField.getText())).exists() && !dir.mkdirs() || !dir.isDirectory())) {
            return new ValidationInfo("Please enter valid library files path", (JComponent)this.myDirectoryField.getTextField());
        }
        return super.doValidate();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myProgressIcon);
        PropertiesComponent storage2 = PropertiesComponent.getInstance((Project)this.myProject);
        storage2.setValue(PROPERTY_DOWNLOAD_TO_PATH_ENABLED, String.valueOf(this.myDownloadToCheckBox.isSelected()));
        String downloadPath = this.myDirectoryField.getText();
        if (StringUtil.isEmptyOrSpaces((String)downloadPath)) {
            downloadPath = this.myDefaultDownloadFolder;
        }
        storage2.setValue(PROPERTY_DOWNLOAD_TO_PATH, downloadPath, this.myDefaultDownloadFolder);
        storage2.setValue(PROPERTY_ATTACH_JAVADOC, String.valueOf(this.myJavaDocCheckBox.isSelected()));
        storage2.setValue(PROPERTY_ATTACH_SOURCES, String.valueOf(this.mySourcesCheckBox.isSelected()));
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return RepositoryAttachDialog.class.getName();
    }

    private boolean isValidCoordinateSelected() {
        String text2 = this.getCoordinateText();
        return text2.split(":").length == 3;
    }

    public String getCoordinateText() {
        JTextField field = (JTextField)this.myCombobox.getEditor().getEditorComponent();
        return field.getText();
    }

    private void createUIComponents() {
        this.myProgressIcon = new AsyncProcessIcon("Progress");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySourcesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Sources");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myJavaDocCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("JavaDocs");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(4);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIncludeTransitiveDepsCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Transitive dependencies");
        jBCheckBox2.setMnemonic('T');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jBCheckBox2.setSelected(true);
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 15, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myComboComponent = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myProgressIcon;
        jPanel3.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfoLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Info");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCaptionLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Description");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myDownloadToCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Download to:  ");
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class LibItem
    implements Comparable<LibItem> {
        final String prefix;
        final Version ver;
        final String coord;

        public LibItem(String coord) {
            this.coord = coord;
            JpsMavenRepositoryLibraryDescriptor desc = new JpsMavenRepositoryLibraryDescriptor(coord);
            this.prefix = desc.getGroupId() + ":" + desc.getArtifactId();
            Version ver = null;
            try {
                ver = ArtifactRepositoryManager.asVersion((String)desc.getVersion());
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
            this.ver = ver;
        }

        @Override
        public int compareTo(@NotNull LibItem that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/jarRepository/RepositoryAttachDialog$LibItem", "compareTo"));
            }
            int prefixCompare = this.prefix.compareTo(that.prefix);
            return prefixCompare != 0 ? prefixCompare : Comparing.compare((Comparable)that.ver, (Comparable)this.ver);
        }
    }
}

