/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.google.common.base.Predicate;
import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySynchronizer
implements StartupActivity,
DumbAware {
    private static boolean isLibraryNeedToBeReloaded(LibraryEx library, RepositoryLibraryProperties properties) {
        String version = properties.getVersion();
        if (version == null) {
            return false;
        }
        if (version.equals("LATEST") || version.equals("RELEASE") || version.endsWith("-SNAPSHOT")) {
            return true;
        }
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (library.getFiles(orderRootType).length == library.getUrls(orderRootType).length) continue;
            return true;
        }
        return false;
    }

    private static Collection<Library> collectLibraries(@NotNull Project project2, @NotNull Predicate<Library> predicate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "collectLibraries"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "collectLibraries"));
        }
        HashSet result2 = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$collectLibraries$1"));
            }
            if (predicate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$collectLibraries$1"));
            }
            if (project2.isDisposed()) {
                return;
            }
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                OrderEnumerator.orderEntries((Module)module2).withoutSdk().forEachLibrary(library -> {
                    if (predicate == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$null$0"));
                    }
                    if (predicate.apply(library)) {
                        result2.add(library);
                    }
                    return true;
                });
            }
            for (Module module3 : ProjectLibraryTable.getInstance(project2).getLibraries()) {
                if (!predicate.apply((Object)module3)) continue;
                result2.add((Object)module3);
            }
        });
        return result2;
    }

    private static void removeDuplicatedUrlsFromRepositoryLibraries(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "removeDuplicatedUrlsFromRepositoryLibraries"));
        }
        Collection<Library> libraries = RepositoryLibrarySynchronizer.collectLibraries(project2, (Predicate<Library>)((Predicate)library -> library instanceof LibraryEx && ((LibraryEx)library).getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.hasDuplicatedRoots(library)));
        if (!libraries.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$removeDuplicatedUrlsFromRepositoryLibraries$4"));
                }
                List validLibraries = ContainerUtil.filter((Collection)libraries, LibraryTableImplUtil::isValidLibrary);
                if (validLibraries.isEmpty()) {
                    return;
                }
                WriteAction.run(() -> {
                    for (Library library : validLibraries) {
                        Library.ModifiableModel model = library.getModifiableModel();
                        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
                            String[] urls = model.getUrls(type2);
                            LinkedHashSet<String> uniqueUrls = new LinkedHashSet<String>(Arrays.asList(urls));
                            if (uniqueUrls.size() == urls.length) continue;
                            for (String url : urls) {
                                model.removeRoot(url, type2);
                            }
                            for (String url : uniqueUrls) {
                                model.addRoot(url, type2);
                            }
                        }
                        model.commit();
                    }
                });
                String libraryText = validLibraries.size() == 1 ? "'" + LibraryUtil.getPresentableName((Library)((Library)validLibraries.iterator().next())) + "' library" : validLibraries.size() + " libraries";
                Notifications.Bus.notify((Notification)new Notification("Repository", "Repository libraries cleanup", "Duplicated URLs were removed from " + libraryText + ". These duplicated URLs were produced due to a bug in a previous " + ApplicationNamesInfo.getInstance().getFullProductName() + " version and might cause performance issues.", NotificationType.INFORMATION), (Project)project2);
            }, project2.getDisposed());
        }
    }

    private static boolean hasDuplicatedRoots(Library library) {
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            Object[] urls = library.getUrls(type2);
            if (urls.length == ContainerUtil.set((Object[])urls).size()) continue;
            return true;
        }
        return false;
    }

    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "runActivity"));
        }
        final Runnable syncTask = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$runActivity$7"));
            }
            Collection<Library> toSync = RepositoryLibrarySynchronizer.collectLibraries(project2, (Predicate<Library>)((Predicate)library -> {
                if (library instanceof LibraryEx) {
                    LibraryEx libraryEx = (LibraryEx)library;
                    return libraryEx.getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.isLibraryNeedToBeReloaded(libraryEx, (RepositoryLibraryProperties)libraryEx.getProperties());
                }
                return false;
            }));
            ApplicationManager.getApplication().invokeLater((Runnable)((DumbAwareRunnable)() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$null$6"));
                }
                for (Library library : toSync) {
                    if (!LibraryTableImplUtil.isValidLibrary(library)) continue;
                    RepositoryUtils.reloadDependencies(project2, (LibraryEx)library);
                }
            }), project2.getDisposed());
        };
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private final Alarm myAlarm;
            {
                this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
            }

            public void rootsChanged(ModuleRootEvent event) {
                if (!this.myAlarm.isDisposed() && event.getSource() instanceof Project) {
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(syncTask, 300L);
                }
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibrarySynchronizer", "lambda$runActivity$8"));
            }
            RepositoryLibrarySynchronizer.removeDuplicatedUrlsFromRepositoryLibraries(project2);
            syncTask.run();
        });
    }
}

