/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryWithDescriptionEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryType
extends LibraryType<RepositoryLibraryProperties> {
    public static final PersistentLibraryKind<RepositoryLibraryProperties> REPOSITORY_LIBRARY_KIND = new PersistentLibraryKind<RepositoryLibraryProperties>("repository"){

        @NotNull
        public RepositoryLibraryProperties createDefaultProperties() {
            RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties();
            if (repositoryLibraryProperties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryLibraryType$1", "createDefaultProperties"));
            }
            return repositoryLibraryProperties;
        }
    };

    protected RepositoryLibraryType() {
        super(REPOSITORY_LIBRARY_KIND);
    }

    public static RepositoryLibraryType getInstance() {
        return (RepositoryLibraryType)EP_NAME.findExtension(RepositoryLibraryType.class);
    }

    @Override
    @Nullable
    public String getCreateActionName() {
        return "From Maven...";
    }

    @Override
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project2) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/jarRepository/RepositoryLibraryType", "createNewLibrary"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryLibraryType", "createNewLibrary"));
        }
        return JarRepositoryManager.chooseLibraryAndDownload(project2, null, parentComponent);
    }

    @Override
    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<RepositoryLibraryProperties> component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/jarRepository/RepositoryLibraryType", "createPropertiesEditor"));
        }
        return new RepositoryLibraryWithDescriptionEditor(component);
    }

    @Override
    @Nullable
    public Icon getIcon(@Nullable RepositoryLibraryProperties properties) {
        if (properties == null || properties.getGroupId() == null || properties.getArtifactId() == null) {
            return RepositoryLibraryDescription.DEFAULT_ICON;
        }
        return RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties).getIcon();
    }

    @Override
    @NotNull
    public String getDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/jarRepository/RepositoryLibraryType", "getDescription"));
        }
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties);
        String string = description.getDisplayName(properties.getVersion());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryLibraryType", "getDescription"));
        }
        return string;
    }
}

