/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.jarRepository.RepositoryAddLibraryAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;

public abstract class RepositoryUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @NotNull
    private static String getFQTypeName(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
        }
        while (ref.getParent() != null && ref.getParent() instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)ref.getParent();
        }
        String name2 = ref.getCanonicalText();
        PsiFile file2 = ref.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
            }
            return string;
        }
        String suffix = "." + name2;
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            for (PsiImportStatement importStatement : importList.getImportStatements()) {
                String qualifiedName = importStatement.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.endsWith(suffix) && !qualifiedName.equals(name2)) continue;
                String string = qualifiedName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
                }
                return string;
            }
        }
        String string = name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "getFQTypeName"));
        }
        return string;
    }

    protected abstract boolean isSuspectedName(@NotNull String var1);

    @NotNull
    protected abstract RepositoryLibraryDescription getLibraryDescription();

    @Override
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)ref);
        if (module2 != null && this.isSuspectedName(RepositoryUnresolvedReferenceQuickFixProvider.getFQTypeName(ref))) {
            registrar.register((IntentionAction)new RepositoryAddLibraryAction(module2, this.getLibraryDescription()));
        }
    }

    @Override
    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }
}

