/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.artifactory;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.artifactory.ArtifactoryModel;
import com.intellij.jarRepository.services.artifactory.Endpoint;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactoryRepositoryService
extends MavenRepositoryService {
    @Override
    @NotNull
    public String getDisplayName() {
        if ("Artifactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "getDisplayName"));
        }
        return "Artifactory";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        ArrayList<RemoteRepositoryDescription> arrayList;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "getRepositories"));
        }
        try {
            Gson gson2 = new Gson();
            InputStreamReader stream = new InputStreamReader(new Endpoint.Repositories(url).getRepositoryDetailsListJson(null).getInputStream());
            ArtifactoryModel.RepositoryType[] repos = (ArtifactoryModel.RepositoryType[])gson2.fromJson((Reader)stream, ArtifactoryModel.RepositoryType[].class);
            ArrayList<RemoteRepositoryDescription> result2 = new ArrayList<RemoteRepositoryDescription>(repos.length);
            for (ArtifactoryModel.RepositoryType repo : repos) {
                result2.add(ArtifactoryRepositoryService.convert(repo));
            }
            arrayList = result2;
        }
        catch (JsonSyntaxException e) {
            List<RemoteRepositoryDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "getRepositories"));
            }
            return list2;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "getRepositories"));
        }
        return arrayList;
    }

    private static RemoteRepositoryDescription convert(ArtifactoryModel.RepositoryType repo) {
        return new RemoteRepositoryDescription(repo.key, repo.description, repo.url);
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        ArrayList<RepositoryArtifactDescription> arrayList;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "findArtifacts"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "findArtifacts"));
        }
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            ArrayList<RepositoryArtifactDescription> artifacts = new ArrayList<RepositoryArtifactDescription>();
            Gson gson2 = new Gson();
            String className = template.getClassNames();
            if (className == null || className.length() == 0) {
                ArtifactoryModel.GavcResults results;
                String name2 = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
                InputStream stream = new Endpoint.Search.Artifact(url).getArtifactSearchResultJson(name2, null).getInputStream();
                ArtifactoryModel.GavcResults gavcResults = results = stream == null ? null : (ArtifactoryModel.GavcResults)gson2.fromJson((Reader)new InputStreamReader(stream), ArtifactoryModel.GavcResults.class);
                if (results != null && results.results != null) {
                    for (ArtifactoryModel.GavcResult result2 : results.results) {
                        if (!result2.uri.endsWith(packaging)) continue;
                        artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(result2.uri, url, null));
                    }
                }
            } else {
                ArtifactoryModel.ArchiveResults results;
                String searchString = className.endsWith("*") || className.endsWith("?") ? className : className + ".class";
                InputStream stream = new Endpoint.Search.Archive(url).getArchiveSearchResultJson(searchString, null).getInputStream();
                ArtifactoryModel.ArchiveResults archiveResults = results = stream == null ? null : (ArtifactoryModel.ArchiveResults)gson2.fromJson((Reader)new InputStreamReader(stream), ArtifactoryModel.ArchiveResults.class);
                if (results != null && results.results != null) {
                    for (ArtifactoryModel.ArchiveResult result3 : results.results) {
                        for (String uri : result3.archiveUris) {
                            if (!uri.endsWith(packaging)) continue;
                            artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(uri, url, result3.entry));
                        }
                    }
                }
            }
            arrayList = artifacts;
        }
        catch (JsonSyntaxException e) {
            List<RepositoryArtifactDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "findArtifacts"));
            }
            return list2;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService", "findArtifacts"));
        }
        return arrayList;
    }

    private static RepositoryArtifactDescription convertArtifactInfo(String uri, String baseUri, String className) throws IOException {
        int repoIndex;
        String repoPathFile = uri.substring((baseUri + "storage/").length());
        String repoString = repoPathFile.substring(0, repoIndex = repoPathFile.indexOf(47));
        String repo = repoString.endsWith("-cache") ? repoString.substring(0, repoString.lastIndexOf(45)) : repoString;
        String filePath = repoPathFile.substring(repoIndex + 1, repoPathFile.lastIndexOf(47));
        int artIdIndex = filePath.lastIndexOf(47);
        String version = filePath.substring(artIdIndex + 1);
        String groupArtifact = filePath.substring(0, artIdIndex);
        int groupIndex = groupArtifact.lastIndexOf(47);
        String artifact = groupArtifact.substring(groupIndex + 1);
        String group = groupArtifact.substring(0, groupIndex).replace('/', '.');
        String packaging = uri.substring(uri.lastIndexOf(46) + 1);
        return new RepositoryArtifactDescription(group, artifact, version, packaging, null, className, repo);
    }
}

