/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.nexus;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.nexus.ArtifactType;
import com.intellij.jarRepository.services.nexus.Endpoint;
import com.intellij.jarRepository.services.nexus.RepositoryType;
import com.intellij.jarRepository.services.nexus.SearchResults;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexusRepositoryService
extends MavenRepositoryService {
    @Nullable
    public static RemoteRepositoryDescription convertRepositoryInfo(@NotNull RepositoryType repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "convertRepositoryInfo"));
        }
        String id = repo.getId();
        if (id == null) {
            return null;
        }
        String name2 = repo.getName();
        if (name2 == null) {
            return null;
        }
        String uri = repo.getContentResourceURI();
        if (uri == null) {
            return null;
        }
        return new RemoteRepositoryDescription(id, name2, uri);
    }

    public static RepositoryArtifactDescription convertArtifactInfo(ArtifactType t) {
        return new RepositoryArtifactDescription(t.getGroupId(), t.getArtifactId(), t.getVersion(), t.getPackaging(), t.getClassifier(), null, t.getRepoId());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Nexus" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "getDisplayName"));
        }
        return "Nexus";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        SmartList smartList;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "getRepositories"));
        }
        try {
            List<RepositoryType> repos = new Endpoint.Repositories(url).getRepolistAsRepositories().getData().getRepositoriesItem();
            SmartList result2 = new SmartList();
            for (RepositoryType repo : repos) {
                RemoteRepositoryDescription desc;
                if (!"maven2".equals(repo.getProvider()) || (desc = NexusRepositoryService.convertRepositoryInfo(repo)) == null) continue;
                result2.add(desc);
            }
            smartList = result2;
        }
        catch (UnmarshalException e) {
            List<RemoteRepositoryDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "getRepositories"));
            }
            return list2;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "getRepositories"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        ArrayList<RepositoryArtifactDescription> arrayList;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "findArtifacts"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "findArtifacts"));
        }
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            String name2 = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
            SearchResults results = new Endpoint.DataIndex(url).getArtifactlistAsSearchResults(name2, template.getGroupId(), template.getArtifactId(), template.getVersion(), null, template.getClassNames());
            SearchResults.Data data = results.getData();
            ArrayList<RepositoryArtifactDescription> result2 = new ArrayList<RepositoryArtifactDescription>();
            if (data != null) {
                for (ArtifactType each : data.getArtifact()) {
                    if (!Comparing.equal((String)each.packaging, (String)packaging)) continue;
                    result2.add(NexusRepositoryService.convertArtifactInfo(each));
                }
            }
            arrayList = result2;
        }
        catch (UnmarshalException e) {
            List<RepositoryArtifactDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "findArtifacts"));
            }
            return list2;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/nexus/NexusRepositoryService", "findArtifacts"));
        }
        return arrayList;
    }
}

