/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static <T> T as(@Nullable Object expression2, @NotNull Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/json/JsonUtil", "as"));
        }
        if (expression2 == null) {
            return null;
        }
        if (cls.isAssignableFrom(expression2.getClass())) {
            return (T)expression2;
        }
        return null;
    }

    @Nullable
    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name2, @NotNull Class<T> clazz) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/JsonUtil", "getPropertyValueOfType"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/JsonUtil", "getPropertyValueOfType"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/json/JsonUtil", "getPropertyValueOfType"));
        }
        JsonProperty property = object.findProperty(name2);
        if (property == null) {
            return null;
        }
        return (T)((JsonElement)ObjectUtils.tryCast((Object)property.getValue(), clazz));
    }

    @Nullable
    public static List<String> getChildAsStringList(@NotNull JsonObject object, @NotNull String name2) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/JsonUtil", "getChildAsStringList"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/JsonUtil", "getChildAsStringList"));
        }
        JsonArray array = JsonUtil.getPropertyValueOfType(object, name2, JsonArray.class);
        if (array != null) {
            return array.getValueList().stream().filter(value2 -> value2 instanceof JsonStringLiteral).map(value2 -> StringUtil.unquoteString((String)value2.getText())).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsSingleStringOrList(@NotNull JsonObject object, @NotNull String name2) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/JsonUtil", "getChildAsSingleStringOrList"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/JsonUtil", "getChildAsSingleStringOrList"));
        }
        List<String> list2 = JsonUtil.getChildAsStringList(object, name2);
        if (list2 != null) {
            return list2;
        }
        JsonStringLiteral literal = JsonUtil.getPropertyValueOfType(object, name2, JsonStringLiteral.class);
        return literal == null ? null : Collections.singletonList(StringUtil.unquoteString((String)literal.getText()));
    }
}

