/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;

public class JsonElementGenerator {
    private final Project myProject;

    public JsonElementGenerator(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/json/psi/JsonElementGenerator", "<init>"));
        }
        this.myProject = project2;
    }

    @NotNull
    public PsiFile createDummyFile(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/json/psi/JsonElementGenerator", "createDummyFile"));
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.myProject);
        PsiFile psiFile = psiFileFactory.createFileFromText("dummy." + JsonFileType.INSTANCE.getDefaultExtension(), (FileType)JsonFileType.INSTANCE, (CharSequence)content);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonElementGenerator", "createDummyFile"));
        }
        return psiFile;
    }

    @NotNull
    public <T extends JsonValue> T createValue(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/json/psi/JsonElementGenerator", "createValue"));
        }
        PsiFile file2 = this.createDummyFile("{\"foo\": " + content + "}");
        JsonValue jsonValue = ((JsonObject)file2.getFirstChild()).getPropertyList().get(0).getValue();
        if (jsonValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonElementGenerator", "createValue"));
        }
        return (T)jsonValue;
    }

    @NotNull
    public JsonObject createObject(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/json/psi/JsonElementGenerator", "createObject"));
        }
        PsiFile file2 = this.createDummyFile("{" + content + "}");
        JsonObject jsonObject = (JsonObject)file2.getFirstChild();
        if (jsonObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonElementGenerator", "createObject"));
        }
        return jsonObject;
    }

    @NotNull
    public JsonStringLiteral createStringLiteral(@NotNull String unescapedContent) {
        if (unescapedContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unescapedContent", "com/intellij/json/psi/JsonElementGenerator", "createStringLiteral"));
        }
        JsonStringLiteral jsonStringLiteral = (JsonStringLiteral)this.createValue('\"' + StringUtil.escapeStringCharacters((String)unescapedContent) + '\"');
        if (jsonStringLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonElementGenerator", "createStringLiteral"));
        }
        return jsonStringLiteral;
    }

    @NotNull
    public JsonProperty createProperty(@NotNull String name2, @NotNull String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/psi/JsonElementGenerator", "createProperty"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/json/psi/JsonElementGenerator", "createProperty"));
        }
        PsiFile file2 = this.createDummyFile("{\"" + name2 + "\": " + value2 + "}");
        JsonProperty jsonProperty = ((JsonObject)file2.getFirstChild()).getPropertyList().get(0);
        if (jsonProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonElementGenerator", "createProperty"));
        }
        return jsonProperty;
    }

    @NotNull
    public PsiElement createComma() {
        JsonArray jsonArray1 = (JsonArray)this.createValue("[1, 2]");
        PsiElement psiElement = jsonArray1.getValueList().get(0).getNextSibling();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonElementGenerator", "createComma"));
        }
        return psiElement;
    }
}

