/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonElementImpl;
import com.intellij.json.psi.impl.JsonPropertyNameReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class JsonPropertyMixin
extends JsonElementImpl
implements JsonProperty {
    public JsonPropertyMixin(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/psi/impl/JsonPropertyMixin", "<init>"));
        }
        super(node);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/psi/impl/JsonPropertyMixin", "setName"));
        }
        JsonElementGenerator generator = new JsonElementGenerator(this.getProject());
        this.getNameElement().replace(generator.createStringLiteral(StringUtil.unquoteString((String)name2)));
        return this;
    }

    @Override
    public PsiReference getReference() {
        return new JsonPropertyNameReference(this);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        Object[] fromProviders = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.prepend((Object)new JsonPropertyNameReference(this), (Object[])fromProviders);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPropertyMixin", "getReferences"));
        }
        return psiReferenceArray;
    }
}

