/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ReadOnlyASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraverserBasedASTNode<N>
extends ReadOnlyASTNode {
    protected final N myNode;
    protected final SyntaxTraverser<N> myTraverser;
    private volatile PsiElement myPsi;
    private volatile ASTNode[] myKids;
    private static final AtomicFieldUpdater<TraverserBasedASTNode, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(TraverserBasedASTNode.class, PsiElement.class);
    private static final AtomicFieldUpdater<TraverserBasedASTNode, ASTNode[]> ourKidsUpdater = AtomicFieldUpdater.forFieldOfType(TraverserBasedASTNode.class, ASTNode[].class);

    @NotNull
    public static <N> FileASTNode createFileNode(@NotNull SyntaxTraverser<N> traverser, @NotNull N node, @NotNull PsiFile psiFile) {
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/lang/TraverserBasedASTNode", "createFileNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode", "createFileNode"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/TraverserBasedASTNode", "createFileNode"));
        }
        FileNode<N> fileNode = new FileNode<N>(traverser, node, psiFile);
        if (fileNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "createFileNode"));
        }
        return fileNode;
    }

    @NotNull
    public static FileViewProvider createViewProvider(@NotNull String fileName, @NotNull Language language, @NotNull PsiManager psiManager) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/TraverserBasedASTNode", "createViewProvider"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/TraverserBasedASTNode", "createViewProvider"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/TraverserBasedASTNode", "createViewProvider"));
        }
        ReadOnlyViewProvider readOnlyViewProvider = new ReadOnlyViewProvider(fileName, language, psiManager);
        if (readOnlyViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "createViewProvider"));
        }
        return readOnlyViewProvider;
    }

    public TraverserBasedASTNode(@NotNull N node, int index, @Nullable TraverserBasedASTNode<?> parent, @NotNull SyntaxTraverser<N> traverser) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode", "<init>"));
        }
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/lang/TraverserBasedASTNode", "<init>"));
        }
        super(parent, index);
        this.myTraverser = traverser;
        this.myNode = node;
    }

    @NotNull
    public IElementType getElementType() {
        IElementType iElementType = this.myTraverser.api.typeOf(this.myNode);
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "getElementType"));
        }
        return iElementType;
    }

    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myTraverser.api.textOf(this.myNode);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "getChars"));
        }
        return charSequence;
    }

    public TextRange getTextRange() {
        return this.myTraverser.api.rangeOf(this.myNode);
    }

    @Override
    protected ASTNode[] getChildArray() {
        ASTNode[] kids = this.myKids;
        if (kids != null) {
            return kids;
        }
        kids = this.childrenImpl();
        return ourKidsUpdater.compareAndSet((Object)this, null, (Object)kids) ? kids : this.myKids;
    }

    private ASTNode[] childrenImpl() {
        List children2 = this.myTraverser.children(this.myNode).transform(this.CHILD_TRANSFORM(this.myTraverser, 0)).toList();
        if (!children2.isEmpty() || this.getTreeParent() == null) {
            return children2.isEmpty() ? EMPTY_ARRAY : children2.toArray(new ASTNode[children2.size()]);
        }
        IElementType type2 = this.myTraverser.api.typeOf(this.myNode);
        if (!(type2 instanceof ILazyParseableElementType)) {
            return EMPTY_ARRAY;
        }
        PsiBuilder builder = ((ILazyParseableElementType)type2).parseLight((ASTNode)this);
        SyntaxTraverser s = SyntaxTraverser.lightTraverser((PsiBuilder)builder);
        int shift = this.myTraverser.api.rangeOf(this.myNode).getStartOffset();
        List childrenLazy = s.api.children(s.getRoot()).transform(this.CHILD_TRANSFORM(s, shift)).toList();
        return childrenLazy.toArray(new ASTNode[childrenLazy.size()]);
    }

    @NotNull
    protected <NN> TraverserBasedASTNode<NN> createChildNode(int index, NN input, SyntaxTraverser<NN> s, int shift) {
        TraverserBasedASTNode<NN> traverserBasedASTNode = shift == 0 ? new TraverserBasedASTNode<NN>(input, index, this, s) : new ShiftedNode<NN>(this, index, shift, s, input);
        if (traverserBasedASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "createChildNode"));
        }
        return traverserBasedASTNode;
    }

    public PsiElement getPsi() {
        PsiElement psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getPsiImpl();
        return ourPsiUpdater.compareAndSet((Object)this, null, (Object)psi) ? psi : this.myPsi;
    }

    public PsiElement getPsiImpl() {
        IElementType type2 = this.getElementType();
        ParserDefinition pd = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type2.getLanguage());
        if (pd != null && pd.getWhitespaceTokens().contains(type2) || pd == null && type2 == TokenType.WHITE_SPACE) {
            return new PsiWhiteSpaceImpl(this.getChars());
        }
        if (pd != null && pd.getCommentTokens().contains(type2)) {
            return new ASTWrapperPsiComment(this);
        }
        if (pd == null || this.myNode instanceof LighterASTTokenNode) {
            return new ASTWrapperPsiElement(this);
        }
        return pd.createElement((ASTNode)this);
    }

    @NotNull
    private <NN> Function<NN, ASTNode> CHILD_TRANSFORM(final SyntaxTraverser<NN> s, final int shift) {
        Function function = new Function<NN, ASTNode>(){
            int index = 0;

            public ASTNode fun(@Nullable NN input) {
                return TraverserBasedASTNode.this.createChildNode(this.index++, input, s, shift);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "CHILD_TRANSFORM"));
        }
        return function;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TraverserBasedASTNode)) {
            return false;
        }
        return Comparing.equal(this.myNode, ((TraverserBasedASTNode)((Object)obj)).myNode);
    }

    public int hashCode() {
        return this.myNode.hashCode();
    }

    @NotNull
    public static PsiElement[] getChildrenAsPsiArray(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode", "getChildrenAsPsiArray"));
        }
        ASTNode[] kids = ((ReadOnlyASTNode)node).getChildArray();
        if (kids.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "getChildrenAsPsiArray"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] result2 = new PsiElement[kids.length];
        int idx = 0;
        for (ASTNode o : kids) {
            PsiElement psi = o.getPsi();
            if (psi == null) continue;
            result2[idx++] = psi;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode", "getChildrenAsPsiArray"));
        }
        return result2;
    }

    @Nullable
    public static PsiElement getFirstPsiChild(@NotNull ASTNode node) {
        ASTNode[] kids;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode", "getFirstPsiChild"));
        }
        for (ASTNode o : kids = ((ReadOnlyASTNode)node).getChildArray()) {
            PsiElement psi = o.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    @Nullable
    public static PsiElement getLastPsiChild(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode", "getLastPsiChild"));
        }
        ASTNode[] kids = ((ReadOnlyASTNode)node).getChildArray();
        for (int i2 = kids.length - 1; i2 >= 0; --i2) {
            ASTNode o = kids[i2];
            PsiElement psi = o.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    private static class ReadOnlyViewProvider
    extends SingleRootFileViewProvider {
        ReadOnlyViewProvider(@NotNull String name2, @NotNull Language language, @NotNull PsiManager psiManager) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "<init>"));
            }
            if (psiManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "<init>"));
            }
            super(psiManager, (VirtualFile)new LightVirtualFile(name2, language, (CharSequence)""), false);
        }

        @Override
        @Nullable
        protected PsiFile createFile(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FileType fileType) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "createFile"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "createFile"));
            }
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "createFile"));
            }
            throw new UnsupportedOperationException("Should not try to create mutable PSI");
        }

        @Override
        @Nullable
        protected PsiFile createFile(@NotNull Language lang) {
            if (lang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider", "createFile"));
            }
            throw new UnsupportedOperationException("Should not try to create mutable PSI");
        }
    }

    private static class ASTWrapperPsiComment
    extends ASTWrapperPsiElement
    implements PsiComment {
        public ASTWrapperPsiComment(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode$ASTWrapperPsiComment", "<init>"));
            }
            super(node);
        }

        public IElementType getTokenType() {
            return this.getNode().getElementType();
        }
    }

    private static class ShiftedNode<N>
    extends TraverserBasedASTNode<N> {
        private final int myShift;

        ShiftedNode(TraverserBasedASTNode<?> parent, int index, int shift, @NotNull SyntaxTraverser<N> traverser, @NotNull N node) {
            if (traverser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/lang/TraverserBasedASTNode$ShiftedNode", "<init>"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode$ShiftedNode", "<init>"));
            }
            super(node, index, parent, traverser);
            this.myShift = shift;
        }

        @Override
        public TextRange getTextRange() {
            return super.getTextRange().shiftRight(this.myShift);
        }

        @Override
        @NotNull
        protected <NN> TraverserBasedASTNode<NN> createChildNode(int index, NN input, SyntaxTraverser<NN> s, int shift) {
            ShiftedNode<NN> shiftedNode = new ShiftedNode<NN>(this, index, this.myShift + shift, s, input);
            if (shiftedNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode$ShiftedNode", "createChildNode"));
            }
            return shiftedNode;
        }
    }

    private static class FileNode<N>
    extends TraverserBasedASTNode<N>
    implements FileASTNode {
        private final PsiFile myPsiFile;

        FileNode(@NotNull SyntaxTraverser<N> traverser, @NotNull N node, @NotNull PsiFile psiFile) {
            if (traverser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/lang/TraverserBasedASTNode$FileNode", "<init>"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode$FileNode", "<init>"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/TraverserBasedASTNode$FileNode", "<init>"));
            }
            super(node, -1, null, traverser);
            this.myPsiFile = psiFile;
            ((ReadOnlyViewProvider)psiFile.getViewProvider()).forceCachedPsi(psiFile);
        }

        @Override
        public PsiElement getPsi() {
            return this.myPsiFile;
        }

        @NotNull
        public CharTable getCharTable() {
            IdentityCharTable identityCharTable = IdentityCharTable.INSTANCE;
            if (identityCharTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode$FileNode", "getCharTable"));
            }
            return identityCharTable;
        }

        public boolean isParsed() {
            return true;
        }

        @NotNull
        public LighterAST getLighterAST() {
            TreeBackedLighterAST treeBackedLighterAST = new TreeBackedLighterAST((FileASTNode)this);
            if (treeBackedLighterAST == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/TraverserBasedASTNode$FileNode", "getLighterAST"));
            }
            return treeBackedLighterAST;
        }
    }
}

